# -*- coding:utf-8 -*-
# Date:2019-12-16

import sys
import pandas as pd
import pymssql
import re
from sqlalchemy import create_engine
import time

class sql_find():
    
    def __init__ (self, database='ZI_DataBase', localhost=True):
        if localhost:
            self.conn = pymssql.connect(host='localhost', user='zgc',password='1234',database=database,autocommit=True)
            self.engine = create_engine(f'mssql+pymssql://zgc:1234@localhost/{database}')
        else:
            self.conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='admin@2018@)!*',database=database,autocommit=True)
            self.engine = create_engine(f'mssql+pymssql://zgcprice3311:admin@2018@)!*@123.56.115.207/{database}')
        self.cursor = self.conn.cursor()

def jiexi(filename):
    f = open(filename,'r',encoding='utf-8')
    entityRe = r'\[\@.*?\#.*?\*\](?!\#)'
    recommendRe = r'\[\$.*?\#.*?\*\](?!\#)'
    product_data_dict = {}
    for data in f: 
        str = data.split('^')
        sku = str[0]
        product_data_dict[sku] = {}
        for word in re.findall(entityRe,str[1]):
            product_data_dict[sku][word.strip('[@*]').rsplit('#')[1]] = word.strip('[@*]').rsplit('#')[0]
        for word in re.findall(recommendRe,str[1]):
            product_data_dict[sku][word.strip('[$*]').rsplit('#')[1]] = word.strip('[$*]').rsplit('#')[0]
        str_for_name = str[1].replace('$','@')
        standard_name = []
        for word in re.findall(entityRe,str_for_name):
            standard_name.append(word.strip('[@*]').rsplit('#')[0])
        standard_name = ' '.join(standard_name)
        product_data_dict[sku]['new_name'] = standard_name
    return product_data_dict

def param_upload(filename):
    now_time = time.strftime("%Y-%m-%d", time.localtime())
    #filename = 'LXWL_2019-12-12_0101.txt.ann'
    sql_ZIdatabase = sql_find('ZI_DataBase', False)
    source = filename.split('/')[-1].split('.txt')[0].split('@')[0]
    batch = filename.split('/')[-1].split('.txt')[0].split('@')[1]
    subcategorycode = filename.split('/')[-1].split('.')[0].split('@')[2]
    param_data_dict = jiexi(filename)
    update_table = {
                    'batch':[],
                    'source':[],
                    'productId':[],
                    'productName':[],
                    'param':[],
                    'paramAttributeImportant':[],
                    'paramAttributeMatch':[],
                    'paramAttributeStandard':[],
                    'value':[],
                    'paramSource':[],
                    'state':[],
                    'subcategorycode':[]
                    }
    for productid in param_data_dict.keys():
        #sql_ZIdatabase.cursor.execute(f"select productName,paramAttributeImportant,paramAttributeMatch,paramAttributeStandard from Product_Api_Data where batch='{batch}' and source='{source}' and productId='{productid}'")
        sql_ZIdatabase.cursor.execute(f"select producrName from Product_Api_Data where batch='{batch}' and source='{source}' and productId='{productid}'")
        product_name_data = sql_ZIdatabase.cursor.fetchone()
        if product_name_data == None:
            continue
        for productparam in param_data_dict[productid].keys():
            if productparam == 'new_name':
                sql_ZIdatabase.cursor.execute(f"select brandName from Product_Api_Data where batch='{batch}' and source='{source}' and productId='{productid}'")
                brand = sql_ZIdatabase.cursor.fetchone()[0]
                if brand != '没有对应指数品牌':
                    brand = brand.replace('/',' ')
                    standard_name = ' '.join([brand,param_data_dict[productid][productparam]])
                    sql_ZIdatabase.cursor.execute(f"update Product_Api_Data set newname = '{standard_name}' where batch='{batch}' and source='{source}' and productId='{productid}'")
                else:
                    sql_ZIdatabase.cursor.execute(f"update Product_Api_Data set newname = '{param_data_dict[productid][productparam]}' where batch='{batch}' and source='{source}' and productId='{productid}'")
                continue
            sql_ZIdatabase.cursor.execute(f"select ISimportant,ispeijian,ISbiaozhunzhi from VW_Relation_Property where SubCategoryCode='{subcategorycode}' and SubTitle='{productparam}'")
            product_param_symbol_data = sql_ZIdatabase.cursor.fetchone()
            update_table['batch'].append(batch)
            update_table['source'].append(source)
            update_table['productId'].append(productid)
            update_table['productName'].append(product_name_data[0])
            update_table['param'].append(productparam)
            update_table['paramAttributeImportant'].append(product_param_symbol_data[0])
            update_table['paramAttributeMatch'].append(product_param_symbol_data[1])
            update_table['paramAttributeStandard'].append(product_param_symbol_data[2])
            update_table['value'].append(param_data_dict[productid][productparam])
            update_table['paramSource'].append('模型参数项')
            update_table['state'].append('1')
            update_table['subcategorycode'].append(subcategorycode)
    update_table_df = pd.DataFrame.from_dict(update_table)
    update_table_df.to_excel(f'update_data_{now_time}.xlsx')
    update_table_df.to_sql('Product_Parameter_Process', sql_ZIdatabase.engine, if_exists='append', index=False)

if __name__ == '__main__':
    print(param_upload('JD@20200103@7914.txt.ann'))
