#!/bin/bash
#date:20191216
#explain:监控目录是否发生变化
#by:Satan

CHECKDIR="/root/program/tagdata/data"    #监控目录路径
LOG="/root/program/tagdata/tagdata.log"        #日志存放路径
PYTHON="/root/program/tagdata/test.py"    #调用的


function CheckDir {
    inotifywait -mrq --timefmt '%y-%m-%d %H:%M'  --format '%T %f %e' -e 'create,delete,modify,moved_to' $CHECKDIR|while read event
    do 
        INO_TIME=$(echo $event | awk '{print $1,$2}')        # 把inotify输出切割 把时间部分赋值给INO_TIME
        INO_FILE=$(echo $event | awk '{print $3}')          # 把inotify输出切割 把文件路径部分赋值给INO_FILE
        INO_EVENT=$(echo $event | awk '{print $4}')         # 把inotify输出切割 把事件类型部分赋值给INO_EVENT        
        
        if [[ $INO_EVENT = 'CREATE' ]] && [[ $INO_FILE != .* ]];then        # 判断事件类型(create)
            echo "`date '+%Y-%m-%d %H:%M'` create file: $INO_FILE" >> $LOG
            /root/anaconda3/bin/python $PYTHON create "上传了一个标注文件：${INO_FILE}" $INO_TIME
        fi

        #elif [[ $INO_EVENT = 'CREATE,ISDIR' ]];then
        #    echo "`date '+%Y-%m-%d %H:%M'` create dir: $INO_FILE" >> $LOG
        #    /root/anaconda3/envs/py36/bin/python3 $PYTHON create "创建了一个目录：${INO_FILE}，详情见附件" $LOG
        #fi
        
        if [[ $INO_EVENT = 'DELETE' ]] && [[ $INO_FILE != .* ]];then        # 判断事件类型(delete)
            echo "`date '+%Y-%m-%d %H:%M'` delete file: $INO_FILE" >> $LOG
        #    /root/anaconda3/envs/py36/bin/python3 $PYTHON delete "删除了一个文件：${INO_FILE}，详情见附件" $LOG
        #elif [[ $INO_EVENT = 'DELETE,ISDIR' ]];then
        #    echo "`date '+%Y-%m-%d %H:%M'` delete dir: $INO_FILE" >> $LOG
        #    /root/anaconda3/envs/py36/bin/python3 $PYTHON delete "删除了一个目录：${INO_FILE}，详情见附件" $LOG
        fi
        
        #if [[ $INO_EVENT = 'MODIFY' ]] && [[ $INO_FILE != .* ]];then        # 判断事件类型(modify)
        #    echo "`date '+%Y-%m-%d %H:%M'` modify file: $INO_FILE" >> $LOG
        #    /root/anaconda3/envs/py36/bin/python3 $PYTHON delete "修改了一个文件：${INO_FILE}，详情见附件" $LOG
        #fi


    done
}

CheckDir