from moudules import *
import pandas as pd


sqlserver = sql_find()
def logic_function(table, price_name='jd_price'):
    sku_lyst = []
    price_lyst = []
    m = 0
    for productcode, sku, name, product_price in zip(table['库内已有产品'], table['SKU'], table['NAME'], table[price_name]):
        try:
            if productcode != 'NULL':
                sku_label, symbol = left(productcode, sku, product_price)          #symbol为0为没有修改的，为1为修改了的，为6为放入新品库的。
            else:
                sku_label, symbol = right(sku, name, product_price)
            sku_lyst.append(sku_label)
            if symbol == 1:
                price_lyst.append(m)
            m += 1

            f=open('断点记录.txt','w', encoding="utf-8",errors='ignore')
            f.write(f'{m}\n')           #该文件‘断点记录.txt’第一项保存当前行数，第二项保存需要录入价格系统的行号。
            for price in price_lyst:    #如果中途中断，请对表提取第二项的行进入价格系统，并且删除前第一项的行。
                f.write(f'{price}, ')
            f.close()
        except:
            print(f'在第{m}条出错！')
    print('操作完成！')
    return sku_lyst, price_lyst
            
            
def left(productcode, sku, product_price):        
    state = sqlserver.state_extract(productcode)
    if state == '1' or state == '2' or state == '4':
        sub_class = True     #此处添加判断子类是否正确的函数。
        if sub_class:
            symbol = sqlserver.state_update(productcode, state_num='1')      #此处为在数据库中把状态置'1'。
            price = sqlserver.price_get(productcode)
            if price == '0' or price == 'NULL' or price == '' or price == 'None':
                if product_price == '0' or product_price == 'NULL' or product_price == 'None' or product_price == '':
                    #price = get_price_by_url(sku)       #此函数为利用sku爬取网站价格数据。
                    sqlserver.price_update(productcode, price)
                else :
                    sqlserver.price_update(productcode, product_price)
            return f'{sku}_补齐重要参数', symbol
        else: 
            symbol = sqlserver.state_update(productcode, state_num='6')
            sqlserver.sku_delete(sku)
            return f'{sku}_放入新品建库', symbol
    elif state == '6':
        symbol = 6
        return f'{sku}_放入新品建库', symbol


def right(sku, name, product_price):
    if similar.istrue(name):        #此处为similar类找到数据库中匹配的型号，返回True。
        productcode = similar.productcode_get(name)          #此处为提取与该型号所匹配产品的productcode。
        left(productcode, sku)
    else:
        return f'{sku}_放入新品建库'


def table_save(table, lyst):
    table = table[['库内已有产品', 'NAME', 'jd_price', 'sku_id', 'create_date']]
    table = pd.concat([table, pd.DataFrame(columns=['商户编码'])])
    table = table.reindex(columns=['商户编码', '库内已有产品', 'NAME', 'jd_price', 'sku_id', 'create_date'])

    for i in range(len(table)):
        table.iloc[i, 0] = 'DS-JD'
        table.iloc[i, 4] = f"https://item.jd.com/{table.iloc[i, 4]}.html"

    table = table.rename(columns={'库内已有产品': '产品编码', 'NAME': '产品名称', 'jd_price': '产品价格', 'sku_id': '产品链接', 'create_date': '创建时间'})
    new_table = table.loc[lyst].reset_index(drop = True)
    pre(new_table, '价格录入.csv')


def main():
    table = data_load('new.xlsx').reset_index(drop = True)
    data_list, price_list = logic_function(table)
    try:
        table_save(table, price_list)

        data_list_buqi = []
        data_list_xinping = []
        for val in data_list:
            if val.split('_')[-1] == '补齐重要参数':
                data_list_buqi.append(val.split('_')[-2])
            elif val.split('_')[-1] == '放入新品建库':
                data_list_xinping.append(val.split('_')[-2])

        print('补齐重要参数\n', data_list_buqi)
        print('新品建库\n', data_list_xinping)
        f=open('补齐重要参数.txt','a+', encoding="utf-8",errors='ignore')
        for val in data_list_buqi:
            f.write(val+"\n")
        f.close()
        f=open('新品建库.txt','a+', encoding="utf-8",errors='ignore')
        for val in data_list_xinping:
            f.write(val+"\n")
        f.close()
        print('完成！')
    except:
        print('出错，打印出sku标签列表和价格录入的行号！')
        print(data_list)
        print(price_list)
    


if __name__ == "__main__":
    main()
