# Text Classification with CNN and RNN

使用卷积神经网络进行中文文本分类

## 环境

- Python 3.6.8
- TensorFlow 1.8.0
- numpy
- scikit-learn
- scipy

## 数据集

本训练集由predict_check_data表的17万条产品名称和对应分类组成。

## 预处理

`data_prepare.py`运行该程序，即可根据数据表，生成指定的训练，测试，验证集。

`data/cnews_loader.py`为数据的预处理文件。

- `read_file()`: 读取文件数据;
- `build_vocab()`: 构建词汇表，使用字符级的表示，这一函数会将词汇表存储下来，避免每一次重复处理;
- `read_vocab()`: 读取上一步存储的词汇表，转换为`{词：id}`表示;
- `read_category()`: 将分类目录固定，转换为`{类别: id}`表示;
- `to_words()`: 将一条由id表示的数据重新转换为文字;
- `process_file()`: 将数据集从文字转换为固定长度的id序列表示;
- `batch_iter()`: 为神经网络的训练准备经过shuffle的批次的数据。

经过数据预处理，数据的格式如下：

| Data | Shape | Data | Shape |
| :---------- | :---------- | :---------- | :---------- |
| x_train | [50000, 600] | y_train | [50000, 10] |
| x_val | [5000, 600] | y_val | [5000, 10] |
| x_test | [10000, 600] | y_test | [10000, 10] |

## CNN卷积神经网络

### 配置项

CNN可配置的参数如下所示，在`cnn_model.py`中。

```python
class TCNNConfig(object):
    """CNN配置参数"""

    embedding_dim = 128  # 词向量维度
    seq_length = 300  # 序列长度
    # num_classes = 668  # 类别数
    num_filters = 1024  # 卷积核数目
    kernel_size = 3  # 卷积核尺寸
    vocab_size = 8000  # 词汇表大小

    hidden_dim = 256  # 全连接层神经元

    dropout_keep_prob = 0.55  # dropout保留比例
    learning_rate = 1e-3  # 学习率

    batch_size = 64  # 每批训练大小
    num_epochs = 20  # 总迭代轮次

    print_per_batch = 100  # 每多少轮输出一次结果
    save_per_batch = 10  # 每多少轮存入tensorboard
```

### CNN模型

具体参看`cnn_model.py`的实现。

### 训练与验证


运行 `python run_cnn.py train`，可以开始训练。

> 若之前进行过训练，请把tensorboard/textcnn删除，避免TensorBoard多次训练结果重叠。

```
Configuring CNN model...
Configuring TensorBoard and Saver...
Loading training and validation data...
Time usage: 0:00:14
Training and evaluating...
Epoch: 1
Iter:      0, Train Loss:    8.9, Train Acc:   0.00%, Val Loss:    8.9, Val Acc:   0.00%, Time: 0:00:15
Iter:    100, Train Loss:    7.1, Train Acc:   3.12%, Val Loss:    7.3, Val Acc:   1.75%, Time: 0:00:22 *
Iter:    200, Train Loss:    6.7, Train Acc:   9.38%, Val Loss:    6.9, Val Acc:   7.68%, Time: 0:00:29 *
Iter:    300, Train Loss:    5.8, Train Acc:  20.31%, Val Loss:    6.4, Val Acc:  15.43%, Time: 0:00:35 *
Iter:    400, Train Loss:    5.8, Train Acc:  18.75%, Val Loss:    5.8, Val Acc:  23.33%, Time: 0:00:42 *
Iter:    500, Train Loss:    5.4, Train Acc:  29.69%, Val Loss:    5.3, Val Acc:  30.68%, Time: 0:00:49 *
Iter:    600, Train Loss:    4.1, Train Acc:  40.62%, Val Loss:    5.0, Val Acc:  37.10%, Time: 0:00:56 *
Iter:    700, Train Loss:    4.3, Train Acc:  40.62%, Val Loss:    4.7, Val Acc:  39.64%, Time: 0:01:03 *
Iter:    800, Train Loss:    4.1, Train Acc:  48.44%, Val Loss:    4.5, Val Acc:  43.47%, Time: 0:01:10 *
Iter:    900, Train Loss:    4.2, Train Acc:  37.50%, Val Loss:    4.3, Val Acc:  45.70%, Time: 0:01:17 *
Iter:   1000, Train Loss:    3.0, Train Acc:  56.25%, Val Loss:    4.1, Val Acc:  48.36%, Time: 0:01:23 *
Iter:   1100, Train Loss:    4.3, Train Acc:  50.00%, Val Loss:    4.0, Val Acc:  50.28%, Time: 0:01:30 *
Iter:   1200, Train Loss:    3.5, Train Acc:  53.12%, Val Loss:    3.9, Val Acc:  51.55%, Time: 0:01:37 *
Iter:   1300, Train Loss:    4.2, Train Acc:  50.00%, Val Loss:    3.8, Val Acc:  52.80%, Time: 0:01:44 *
Iter:   1400, Train Loss:    2.6, Train Acc:  59.38%, Val Loss:    3.6, Val Acc:  54.80%, Time: 0:01:51 *
Iter:   1500, Train Loss:    4.0, Train Acc:  51.56%, Val Loss:    3.5, Val Acc:  55.76%, Time: 0:01:58 *
Iter:   1600, Train Loss:    4.1, Train Acc:  46.88%, Val Loss:    3.5, Val Acc:  56.52%, Time: 0:02:05 *
Iter:   1700, Train Loss:    3.0, Train Acc:  59.38%, Val Loss:    3.4, Val Acc:  57.38%, Time: 0:02:12 *
Iter:   1800, Train Loss:    2.9, Train Acc:  60.94%, Val Loss:    3.3, Val Acc:  58.31%, Time: 0:02:19 *
Iter:   1900, Train Loss:    3.8, Train Acc:  50.00%, Val Loss:    3.2, Val Acc:  58.58%, Time: 0:02:26 *
Iter:   2000, Train Loss:    3.9, Train Acc:  54.69%, Val Loss:    3.2, Val Acc:  59.42%, Time: 0:02:33 *
Epoch: 2
Iter:   2100, Train Loss:    2.6, Train Acc:  62.50%, Val Loss:    3.1, Val Acc:  60.42%, Time: 0:02:50 *
Iter:   2200, Train Loss:    2.4, Train Acc:  70.31%, Val Loss:    3.0, Val Acc:  61.14%, Time: 0:02:57 *
Iter:   2300, Train Loss:    2.5, Train Acc:  62.50%, Val Loss:    3.0, Val Acc:  61.55%, Time: 0:03:04 *
Iter:   2400, Train Loss:    1.9, Train Acc:  71.88%, Val Loss:    2.9, Val Acc:  62.67%, Time: 0:03:11 *
Iter:   2500, Train Loss:    2.0, Train Acc:  68.75%, Val Loss:    2.9, Val Acc:  62.93%, Time: 0:03:18 *
Iter:   2600, Train Loss:    2.0, Train Acc:  67.19%, Val Loss:    2.8, Val Acc:  63.42%, Time: 0:03:24 *
Iter:   2700, Train Loss:    2.1, Train Acc:  62.50%, Val Loss:    2.8, Val Acc:  63.86%, Time: 0:03:31 *
Iter:   2800, Train Loss:    2.3, Train Acc:  71.88%, Val Loss:    2.7, Val Acc:  64.37%, Time: 0:03:38 *
Iter:   2900, Train Loss:    2.0, Train Acc:  70.31%, Val Loss:    2.7, Val Acc:  64.58%, Time: 0:03:45 *
Iter:   3000, Train Loss:    2.7, Train Acc:  59.38%, Val Loss:    2.6, Val Acc:  65.34%, Time: 0:03:52 *
Iter:   3100, Train Loss:    1.9, Train Acc:  67.19%, Val Loss:    2.5, Val Acc:  65.78%, Time: 0:03:59 *
Iter:   3200, Train Loss:    1.8, Train Acc:  71.88%, Val Loss:    2.5, Val Acc:  66.57%, Time: 0:04:05 *
Iter:   3300, Train Loss:    2.2, Train Acc:  67.19%, Val Loss:    2.5, Val Acc:  66.99%, Time: 0:04:12 *
Iter:   3400, Train Loss:    2.6, Train Acc:  68.75%, Val Loss:    2.4, Val Acc:  67.20%, Time: 0:04:19 *
Iter:   3500, Train Loss:    2.5, Train Acc:  65.62%, Val Loss:    2.4, Val Acc:  67.61%, Time: 0:04:26 *
Iter:   3600, Train Loss:   0.86, Train Acc:  84.38%, Val Loss:    2.3, Val Acc:  68.21%, Time: 0:04:33 *
Iter:   3700, Train Loss:    1.8, Train Acc:  70.31%, Val Loss:    2.3, Val Acc:  67.93%, Time: 0:04:39
Iter:   3800, Train Loss:    1.4, Train Acc:  78.12%, Val Loss:    2.3, Val Acc:  68.91%, Time: 0:04:46 *
Iter:   3900, Train Loss:    2.0, Train Acc:  71.88%, Val Loss:    2.2, Val Acc:  69.15%, Time: 0:04:53 *
Iter:   4000, Train Loss:    1.7, Train Acc:  71.88%, Val Loss:    2.2, Val Acc:  69.55%, Time: 0:05:00 *
Iter:   4100, Train Loss:    1.3, Train Acc:  79.69%, Val Loss:    2.1, Val Acc:  70.02%, Time: 0:05:07 *
Epoch: 3
Iter:   4200, Train Loss:   0.92, Train Acc:  82.81%, Val Loss:    2.1, Val Acc:  70.36%, Time: 0:05:20 *
Iter:   4300, Train Loss:    0.9, Train Acc:  81.25%, Val Loss:    2.1, Val Acc:  70.28%, Time: 0:05:27
Iter:   4400, Train Loss:    1.4, Train Acc:  81.25%, Val Loss:    2.0, Val Acc:  71.39%, Time: 0:05:33 *
Iter:   4500, Train Loss:    1.3, Train Acc:  78.12%, Val Loss:    2.0, Val Acc:  71.21%, Time: 0:05:40
Iter:   4600, Train Loss:    1.4, Train Acc:  81.25%, Val Loss:    2.0, Val Acc:  72.01%, Time: 0:05:47 *
Iter:   4700, Train Loss:    1.2, Train Acc:  79.69%, Val Loss:    1.9, Val Acc:  72.46%, Time: 0:05:53 *
Iter:   4800, Train Loss:   0.94, Train Acc:  87.50%, Val Loss:    1.9, Val Acc:  72.70%, Time: 0:06:00 *
Iter:   4900, Train Loss:    1.7, Train Acc:  76.56%, Val Loss:    1.9, Val Acc:  73.00%, Time: 0:06:07 *
Iter:   5000, Train Loss:   0.98, Train Acc:  82.81%, Val Loss:    1.8, Val Acc:  73.68%, Time: 0:06:14 *
Iter:   5100, Train Loss:    1.4, Train Acc:  78.12%, Val Loss:    1.8, Val Acc:  73.69%, Time: 0:06:21 *
Iter:   5200, Train Loss:    1.5, Train Acc:  71.88%, Val Loss:    1.8, Val Acc:  74.32%, Time: 0:06:28 *
Iter:   5300, Train Loss:   0.78, Train Acc:  85.94%, Val Loss:    1.8, Val Acc:  74.16%, Time: 0:06:34
Iter:   5400, Train Loss:   0.95, Train Acc:  78.12%, Val Loss:    1.7, Val Acc:  74.41%, Time: 0:06:41 *
Iter:   5500, Train Loss:   0.96, Train Acc:  85.94%, Val Loss:    1.7, Val Acc:  75.29%, Time: 0:06:48 *
Iter:   5600, Train Loss:    1.2, Train Acc:  82.81%, Val Loss:    1.7, Val Acc:  75.43%, Time: 0:06:55 *
Iter:   5700, Train Loss:    1.3, Train Acc:  76.56%, Val Loss:    1.7, Val Acc:  75.19%, Time: 0:07:01
Iter:   5800, Train Loss:    1.0, Train Acc:  81.25%, Val Loss:    1.6, Val Acc:  76.09%, Time: 0:07:08 *
Iter:   5900, Train Loss:    0.8, Train Acc:  81.25%, Val Loss:    1.6, Val Acc:  76.16%, Time: 0:07:15 *
Iter:   6000, Train Loss:    1.2, Train Acc:  76.56%, Val Loss:    1.6, Val Acc:  76.21%, Time: 0:07:22 *
Iter:   6100, Train Loss:    1.3, Train Acc:  78.12%, Val Loss:    1.6, Val Acc:  76.62%, Time: 0:07:29 *
Iter:   6200, Train Loss:   0.92, Train Acc:  85.94%, Val Loss:    1.5, Val Acc:  77.45%, Time: 0:07:35 *
Epoch: 4
Iter:   6300, Train Loss:    0.3, Train Acc:  96.88%, Val Loss:    1.5, Val Acc:  77.37%, Time: 0:07:48
Iter:   6400, Train Loss:   0.72, Train Acc:  89.06%, Val Loss:    1.5, Val Acc:  77.80%, Time: 0:07:54 *
Iter:   6500, Train Loss:   0.46, Train Acc:  90.62%, Val Loss:    1.5, Val Acc:  77.54%, Time: 0:08:01
Iter:   6600, Train Loss:   0.38, Train Acc:  92.19%, Val Loss:    1.5, Val Acc:  78.04%, Time: 0:08:08 *
Iter:   6700, Train Loss:   0.78, Train Acc:  90.62%, Val Loss:    1.4, Val Acc:  78.41%, Time: 0:08:14 *
Iter:   6800, Train Loss:   0.93, Train Acc:  81.25%, Val Loss:    1.4, Val Acc:  78.65%, Time: 0:08:21 *
Iter:   6900, Train Loss:   0.43, Train Acc:  92.19%, Val Loss:    1.4, Val Acc:  79.00%, Time: 0:08:28 *
Iter:   7000, Train Loss:   0.48, Train Acc:  92.19%, Val Loss:    1.4, Val Acc:  78.81%, Time: 0:08:34
Iter:   7100, Train Loss:   0.25, Train Acc:  95.31%, Val Loss:    1.4, Val Acc:  78.78%, Time: 0:08:41
Iter:   7200, Train Loss:   0.79, Train Acc:  84.38%, Val Loss:    1.4, Val Acc:  79.45%, Time: 0:08:48 *
Iter:   7300, Train Loss:   0.64, Train Acc:  89.06%, Val Loss:    1.4, Val Acc:  79.34%, Time: 0:08:54
Iter:   7400, Train Loss:   0.43, Train Acc:  92.19%, Val Loss:    1.3, Val Acc:  79.44%, Time: 0:09:01
Iter:   7500, Train Loss:    0.6, Train Acc:  90.62%, Val Loss:    1.3, Val Acc:  80.37%, Time: 0:09:07 *
Iter:   7600, Train Loss:   0.57, Train Acc:  90.62%, Val Loss:    1.3, Val Acc:  80.30%, Time: 0:09:14
Iter:   7700, Train Loss:   0.59, Train Acc:  85.94%, Val Loss:    1.3, Val Acc:  80.73%, Time: 0:09:21 *
Iter:   7800, Train Loss:   0.35, Train Acc:  92.19%, Val Loss:    1.2, Val Acc:  81.22%, Time: 0:09:28 *
Iter:   7900, Train Loss:   0.37, Train Acc:  92.19%, Val Loss:    1.2, Val Acc:  81.54%, Time: 0:09:34 *
Iter:   8000, Train Loss:   0.67, Train Acc:  84.38%, Val Loss:    1.2, Val Acc:  81.40%, Time: 0:09:41
Iter:   8100, Train Loss:   0.56, Train Acc:  90.62%, Val Loss:    1.2, Val Acc:  81.64%, Time: 0:09:48 *
Iter:   8200, Train Loss:   0.62, Train Acc:  90.62%, Val Loss:    1.2, Val Acc:  81.83%, Time: 0:09:55 *
Iter:   8300, Train Loss:   0.47, Train Acc:  90.62%, Val Loss:    1.1, Val Acc:  81.90%, Time: 0:10:01 *
Epoch: 5
Iter:   8400, Train Loss:   0.36, Train Acc:  93.75%, Val Loss:    1.1, Val Acc:  82.03%, Time: 0:10:14 *
Iter:   8500, Train Loss:   0.48, Train Acc:  90.62%, Val Loss:    1.1, Val Acc:  82.38%, Time: 0:10:21 *
Iter:   8600, Train Loss:   0.91, Train Acc:  82.81%, Val Loss:    1.1, Val Acc:  82.23%, Time: 0:10:28
Iter:   8700, Train Loss:   0.39, Train Acc:  93.75%, Val Loss:    1.1, Val Acc:  82.63%, Time: 0:10:34 *
Iter:   8800, Train Loss:   0.45, Train Acc:  92.19%, Val Loss:    1.1, Val Acc:  83.23%, Time: 0:10:41 *
Iter:   8900, Train Loss:   0.29, Train Acc:  95.31%, Val Loss:    1.1, Val Acc:  83.23%, Time: 0:10:48 *
Iter:   9000, Train Loss:    1.0, Train Acc:  85.94%, Val Loss:    1.1, Val Acc:  83.25%, Time: 0:10:55 *
Iter:   9100, Train Loss:   0.22, Train Acc:  93.75%, Val Loss:    1.1, Val Acc:  82.89%, Time: 0:11:02
Iter:   9200, Train Loss:   0.49, Train Acc:  92.19%, Val Loss:    1.1, Val Acc:  83.14%, Time: 0:11:08
Iter:   9300, Train Loss:   0.34, Train Acc:  92.19%, Val Loss:    1.0, Val Acc:  83.49%, Time: 0:11:15 *
Iter:   9400, Train Loss:   0.25, Train Acc:  96.88%, Val Loss:    1.1, Val Acc:  83.13%, Time: 0:11:22
Iter:   9500, Train Loss:   0.37, Train Acc:  93.75%, Val Loss:    1.0, Val Acc:  84.14%, Time: 0:11:28 *
Iter:   9600, Train Loss:   0.25, Train Acc:  93.75%, Val Loss:   0.99, Val Acc:  83.97%, Time: 0:11:35
Iter:   9700, Train Loss:   0.31, Train Acc:  92.19%, Val Loss:    1.0, Val Acc:  83.88%, Time: 0:11:42
Iter:   9800, Train Loss:   0.31, Train Acc:  92.19%, Val Loss:    1.0, Val Acc:  84.00%, Time: 0:11:48
Iter:   9900, Train Loss:   0.22, Train Acc:  93.75%, Val Loss:   0.96, Val Acc:  84.53%, Time: 0:11:55 *
Iter:  10000, Train Loss:   0.45, Train Acc:  96.88%, Val Loss:   0.96, Val Acc:  84.62%, Time: 0:12:02 *
Iter:  10100, Train Loss:   0.32, Train Acc:  96.88%, Val Loss:   0.94, Val Acc:  84.88%, Time: 0:12:09 *
Iter:  10200, Train Loss:   0.47, Train Acc:  87.50%, Val Loss:   0.96, Val Acc:  84.56%, Time: 0:12:15
Iter:  10300, Train Loss:   0.32, Train Acc:  95.31%, Val Loss:   0.92, Val Acc:  85.14%, Time: 0:12:22 *
Epoch: 6
Iter:  10400, Train Loss:   0.28, Train Acc:  95.31%, Val Loss:   0.92, Val Acc:  84.80%, Time: 0:12:34
Iter:  10500, Train Loss:   0.12, Train Acc:  98.44%, Val Loss:   0.89, Val Acc:  85.43%, Time: 0:12:41 *
Iter:  10600, Train Loss:   0.17, Train Acc:  96.88%, Val Loss:   0.93, Val Acc:  84.99%, Time: 0:12:47
Iter:  10700, Train Loss:   0.35, Train Acc:  92.19%, Val Loss:    0.9, Val Acc:  85.60%, Time: 0:12:54 *
Iter:  10800, Train Loss:   0.22, Train Acc:  96.88%, Val Loss:   0.92, Val Acc:  85.43%, Time: 0:13:01
Iter:  10900, Train Loss:   0.19, Train Acc:  95.31%, Val Loss:   0.88, Val Acc:  85.58%, Time: 0:13:08
Iter:  11000, Train Loss:    0.4, Train Acc:  92.19%, Val Loss:   0.91, Val Acc:  85.28%, Time: 0:13:14
Iter:  11100, Train Loss:   0.22, Train Acc:  93.75%, Val Loss:   0.87, Val Acc:  85.60%, Time: 0:13:21 *
Iter:  11200, Train Loss:   0.14, Train Acc:  98.44%, Val Loss:   0.89, Val Acc:  85.70%, Time: 0:13:27 *
Iter:  11300, Train Loss:    0.2, Train Acc:  92.19%, Val Loss:   0.88, Val Acc:  85.78%, Time: 0:13:34 *
Iter:  11400, Train Loss:    0.3, Train Acc:  92.19%, Val Loss:   0.84, Val Acc:  86.32%, Time: 0:13:41 *
Iter:  11500, Train Loss:   0.26, Train Acc:  93.75%, Val Loss:   0.84, Val Acc:  86.26%, Time: 0:13:48
Iter:  11600, Train Loss:   0.29, Train Acc:  96.88%, Val Loss:   0.81, Val Acc:  86.61%, Time: 0:13:54 *
Iter:  11700, Train Loss:   0.38, Train Acc:  92.19%, Val Loss:   0.81, Val Acc:  86.89%, Time: 0:14:01 *
Iter:  11800, Train Loss:   0.22, Train Acc:  98.44%, Val Loss:   0.79, Val Acc:  86.84%, Time: 0:14:08
Iter:  11900, Train Loss:   0.35, Train Acc:  90.62%, Val Loss:    0.8, Val Acc:  86.77%, Time: 0:14:14
Iter:  12000, Train Loss:   0.14, Train Acc:  98.44%, Val Loss:    0.8, Val Acc:  86.89%, Time: 0:14:21 *
Iter:  12100, Train Loss:   0.13, Train Acc:  95.31%, Val Loss:   0.79, Val Acc:  86.68%, Time: 0:14:28
Iter:  12200, Train Loss:   0.44, Train Acc:  96.88%, Val Loss:   0.78, Val Acc:  87.13%, Time: 0:14:34 *
Iter:  12300, Train Loss:   0.45, Train Acc:  92.19%, Val Loss:   0.76, Val Acc:  87.41%, Time: 0:14:41 *
Iter:  12400, Train Loss:   0.15, Train Acc:  95.31%, Val Loss:   0.76, Val Acc:  87.46%, Time: 0:14:48 *
Epoch: 7
Iter:  12500, Train Loss:  0.092, Train Acc:  98.44%, Val Loss:   0.76, Val Acc:  87.37%, Time: 0:15:00
Iter:  12600, Train Loss:  0.056, Train Acc: 100.00%, Val Loss:   0.73, Val Acc:  87.71%, Time: 0:15:07 *
Iter:  12700, Train Loss:  0.061, Train Acc:  96.88%, Val Loss:   0.74, Val Acc:  87.62%, Time: 0:15:14
Iter:  12800, Train Loss:  0.095, Train Acc:  98.44%, Val Loss:   0.77, Val Acc:  87.07%, Time: 0:15:21
Iter:  12900, Train Loss:   0.12, Train Acc:  95.31%, Val Loss:   0.73, Val Acc:  87.55%, Time: 0:15:27
Iter:  13000, Train Loss:   0.37, Train Acc:  92.19%, Val Loss:   0.74, Val Acc:  87.65%, Time: 0:15:34
Iter:  13100, Train Loss:   0.22, Train Acc:  96.88%, Val Loss:   0.72, Val Acc:  87.91%, Time: 0:15:41 *
Iter:  13200, Train Loss:   0.19, Train Acc:  96.88%, Val Loss:   0.74, Val Acc:  87.53%, Time: 0:15:47
Iter:  13300, Train Loss:   0.21, Train Acc:  93.75%, Val Loss:   0.72, Val Acc:  87.75%, Time: 0:15:54
Iter:  13400, Train Loss:   0.38, Train Acc:  96.88%, Val Loss:   0.71, Val Acc:  88.28%, Time: 0:16:01 *
Iter:  13500, Train Loss:   0.32, Train Acc:  95.31%, Val Loss:   0.72, Val Acc:  88.10%, Time: 0:16:07
Iter:  13600, Train Loss:   0.12, Train Acc:  96.88%, Val Loss:   0.75, Val Acc:  87.65%, Time: 0:16:14
Iter:  13700, Train Loss:   0.27, Train Acc:  93.75%, Val Loss:   0.71, Val Acc:  88.32%, Time: 0:16:21 *
Iter:  13800, Train Loss:   0.25, Train Acc:  95.31%, Val Loss:    0.7, Val Acc:  88.43%, Time: 0:16:27 *
Iter:  13900, Train Loss:   0.15, Train Acc:  95.31%, Val Loss:   0.71, Val Acc:  88.19%, Time: 0:16:34
Iter:  14000, Train Loss:   0.32, Train Acc:  92.19%, Val Loss:   0.69, Val Acc:  88.35%, Time: 0:16:41
Iter:  14100, Train Loss:   0.27, Train Acc:  93.75%, Val Loss:   0.68, Val Acc:  88.20%, Time: 0:16:47
Iter:  14200, Train Loss:  0.044, Train Acc:  98.44%, Val Loss:   0.64, Val Acc:  88.86%, Time: 0:16:54 *
Iter:  14300, Train Loss:    0.1, Train Acc:  96.88%, Val Loss:   0.66, Val Acc:  88.62%, Time: 0:17:01
Iter:  14400, Train Loss:  0.094, Train Acc:  98.44%, Val Loss:   0.65, Val Acc:  88.81%, Time: 0:17:07
Iter:  14500, Train Loss:   0.46, Train Acc:  90.62%, Val Loss:   0.63, Val Acc:  88.93%, Time: 0:17:14 *
Epoch: 8
Iter:  14600, Train Loss:  0.091, Train Acc:  98.44%, Val Loss:   0.63, Val Acc:  88.96%, Time: 0:17:27 *
Iter:  14700, Train Loss:  0.045, Train Acc: 100.00%, Val Loss:   0.62, Val Acc:  89.15%, Time: 0:17:34 *
Iter:  14800, Train Loss:   0.17, Train Acc:  93.75%, Val Loss:   0.64, Val Acc:  88.99%, Time: 0:17:40
Iter:  14900, Train Loss:   0.36, Train Acc:  92.19%, Val Loss:   0.64, Val Acc:  88.99%, Time: 0:17:47
Iter:  15000, Train Loss:   0.13, Train Acc:  96.88%, Val Loss:   0.63, Val Acc:  89.06%, Time: 0:17:54
Iter:  15100, Train Loss:   0.11, Train Acc:  93.75%, Val Loss:   0.64, Val Acc:  88.92%, Time: 0:18:00
Iter:  15200, Train Loss:   0.26, Train Acc:  93.75%, Val Loss:   0.62, Val Acc:  89.28%, Time: 0:18:07 *
Iter:  15300, Train Loss:   0.29, Train Acc:  93.75%, Val Loss:   0.62, Val Acc:  89.14%, Time: 0:18:14
Iter:  15400, Train Loss:    0.1, Train Acc:  96.88%, Val Loss:   0.64, Val Acc:  89.23%, Time: 0:18:20
Iter:  15500, Train Loss:   0.28, Train Acc:  95.31%, Val Loss:   0.61, Val Acc:  89.57%, Time: 0:18:27 *
Iter:  15600, Train Loss:  0.051, Train Acc: 100.00%, Val Loss:    0.6, Val Acc:  89.47%, Time: 0:18:34
Iter:  15700, Train Loss: 0.0053, Train Acc: 100.00%, Val Loss:    0.6, Val Acc:  89.67%, Time: 0:18:40 *
Iter:  15800, Train Loss:   0.11, Train Acc:  95.31%, Val Loss:   0.59, Val Acc:  89.81%, Time: 0:18:47 *
Iter:  15900, Train Loss:  0.054, Train Acc: 100.00%, Val Loss:    0.6, Val Acc:  89.62%, Time: 0:18:54
Iter:  16000, Train Loss:  0.054, Train Acc:  98.44%, Val Loss:   0.59, Val Acc:  89.94%, Time: 0:19:00 *
Iter:  16100, Train Loss:   0.11, Train Acc:  98.44%, Val Loss:   0.58, Val Acc:  89.87%, Time: 0:19:07
Iter:  16200, Train Loss:  0.085, Train Acc:  96.88%, Val Loss:   0.58, Val Acc:  89.88%, Time: 0:19:14
Iter:  16300, Train Loss:   0.19, Train Acc:  96.88%, Val Loss:   0.58, Val Acc:  89.81%, Time: 0:19:20
Iter:  16400, Train Loss:  0.044, Train Acc:  98.44%, Val Loss:   0.59, Val Acc:  89.72%, Time: 0:19:27
Iter:  16500, Train Loss:   0.24, Train Acc:  95.31%, Val Loss:   0.56, Val Acc:  90.15%, Time: 0:19:34 *
Iter:  16600, Train Loss:   0.17, Train Acc:  98.44%, Val Loss:   0.56, Val Acc:  90.04%, Time: 0:19:40
Epoch: 9
Iter:  16700, Train Loss:   0.19, Train Acc:  96.88%, Val Loss:   0.56, Val Acc:  90.17%, Time: 0:19:53 *
Iter:  16800, Train Loss:  0.045, Train Acc:  98.44%, Val Loss:   0.56, Val Acc:  90.28%, Time: 0:20:00 *
Iter:  16900, Train Loss:   0.27, Train Acc:  98.44%, Val Loss:    0.6, Val Acc:  89.78%, Time: 0:20:06
Iter:  17000, Train Loss:   0.17, Train Acc:  98.44%, Val Loss:   0.54, Val Acc:  90.50%, Time: 0:20:13 *
Iter:  17100, Train Loss:  0.018, Train Acc:  98.44%, Val Loss:   0.58, Val Acc:  89.88%, Time: 0:20:20
Iter:  17200, Train Loss:    0.2, Train Acc:  96.88%, Val Loss:   0.55, Val Acc:  90.26%, Time: 0:20:27
Iter:  17300, Train Loss:   0.25, Train Acc:  93.75%, Val Loss:   0.53, Val Acc:  90.63%, Time: 0:20:33 *
Iter:  17400, Train Loss:   0.29, Train Acc:  92.19%, Val Loss:   0.57, Val Acc:  90.32%, Time: 0:20:40
Iter:  17500, Train Loss:   0.06, Train Acc:  96.88%, Val Loss:   0.53, Val Acc:  90.75%, Time: 0:20:47 *
Iter:  17600, Train Loss:   0.14, Train Acc:  96.88%, Val Loss:   0.53, Val Acc:  90.81%, Time: 0:20:53 *
Iter:  17700, Train Loss: 0.0088, Train Acc: 100.00%, Val Loss:   0.56, Val Acc:  90.47%, Time: 0:21:00
Iter:  17800, Train Loss:    0.1, Train Acc:  95.31%, Val Loss:   0.55, Val Acc:  90.26%, Time: 0:21:07
Iter:  17900, Train Loss:   0.22, Train Acc:  95.31%, Val Loss:   0.54, Val Acc:  90.60%, Time: 0:21:13
Iter:  18000, Train Loss:  0.033, Train Acc: 100.00%, Val Loss:   0.55, Val Acc:  90.48%, Time: 0:21:20
Iter:  18100, Train Loss:  0.059, Train Acc:  98.44%, Val Loss:   0.54, Val Acc:  90.66%, Time: 0:21:27
Iter:  18200, Train Loss:  0.067, Train Acc:  98.44%, Val Loss:   0.53, Val Acc:  90.74%, Time: 0:21:33
Iter:  18300, Train Loss:   0.01, Train Acc: 100.00%, Val Loss:   0.53, Val Acc:  90.71%, Time: 0:21:40
Iter:  18400, Train Loss:  0.024, Train Acc: 100.00%, Val Loss:   0.52, Val Acc:  90.61%, Time: 0:21:46
Iter:  18500, Train Loss:  0.085, Train Acc:  98.44%, Val Loss:   0.52, Val Acc:  90.76%, Time: 0:21:53
Iter:  18600, Train Loss:   0.09, Train Acc:  98.44%, Val Loss:    0.5, Val Acc:  90.92%, Time: 0:22:00 *
Epoch: 10
Iter:  18700, Train Loss:   0.11, Train Acc:  96.88%, Val Loss:   0.52, Val Acc:  90.59%, Time: 0:22:12
Iter:  18800, Train Loss:   0.16, Train Acc:  96.88%, Val Loss:   0.51, Val Acc:  90.79%, Time: 0:22:19
Iter:  18900, Train Loss:  0.012, Train Acc: 100.00%, Val Loss:   0.51, Val Acc:  91.04%, Time: 0:22:26 *
Iter:  19000, Train Loss:   0.27, Train Acc:  92.19%, Val Loss:   0.51, Val Acc:  90.98%, Time: 0:22:32
Iter:  19100, Train Loss:   0.12, Train Acc:  96.88%, Val Loss:   0.52, Val Acc:  90.64%, Time: 0:22:39
Iter:  19200, Train Loss:  0.063, Train Acc:  96.88%, Val Loss:   0.49, Val Acc:  91.17%, Time: 0:22:45 *
Iter:  19300, Train Loss:  0.034, Train Acc:  98.44%, Val Loss:   0.52, Val Acc:  90.53%, Time: 0:22:52
Iter:  19400, Train Loss:  0.094, Train Acc:  95.31%, Val Loss:   0.52, Val Acc:  90.90%, Time: 0:22:59
Iter:  19500, Train Loss:   0.11, Train Acc:  98.44%, Val Loss:   0.54, Val Acc:  90.57%, Time: 0:23:05
Iter:  19600, Train Loss:  0.024, Train Acc: 100.00%, Val Loss:   0.46, Val Acc:  91.46%, Time: 0:23:12 *
Iter:  19700, Train Loss: 0.0068, Train Acc: 100.00%, Val Loss:   0.48, Val Acc:  91.59%, Time: 0:23:19 *
Iter:  19800, Train Loss:   0.16, Train Acc:  96.88%, Val Loss:   0.48, Val Acc:  91.71%, Time: 0:23:26 *
Iter:  19900, Train Loss:   0.23, Train Acc:  96.88%, Val Loss:   0.46, Val Acc:  91.60%, Time: 0:23:32
Iter:  20000, Train Loss:   0.01, Train Acc: 100.00%, Val Loss:   0.47, Val Acc:  91.51%, Time: 0:23:39
Iter:  20100, Train Loss:   0.17, Train Acc:  95.31%, Val Loss:   0.47, Val Acc:  91.48%, Time: 0:23:45
Iter:  20200, Train Loss:   0.14, Train Acc:  98.44%, Val Loss:   0.47, Val Acc:  91.40%, Time: 0:23:52
Iter:  20300, Train Loss:  0.082, Train Acc:  96.88%, Val Loss:   0.46, Val Acc:  91.76%, Time: 0:23:59 *
Iter:  20400, Train Loss:   0.15, Train Acc:  98.44%, Val Loss:   0.46, Val Acc:  91.90%, Time: 0:24:06 *
Iter:  20500, Train Loss:  0.033, Train Acc:  96.88%, Val Loss:   0.45, Val Acc:  91.76%, Time: 0:24:12
Iter:  20600, Train Loss:  0.064, Train Acc:  98.44%, Val Loss:   0.46, Val Acc:  91.66%, Time: 0:24:19
Iter:  20700, Train Loss:   0.25, Train Acc:  98.44%, Val Loss:   0.47, Val Acc:  91.59%, Time: 0:24:25
Epoch: 11
Iter:  20800, Train Loss:  0.013, Train Acc: 100.00%, Val Loss:   0.44, Val Acc:  92.10%, Time: 0:24:38 *
Iter:  20900, Train Loss:  0.012, Train Acc: 100.00%, Val Loss:   0.44, Val Acc:  92.15%, Time: 0:24:45 *
Iter:  21000, Train Loss:  0.025, Train Acc:  98.44%, Val Loss:   0.47, Val Acc:  91.75%, Time: 0:24:51
Iter:  21100, Train Loss:  0.026, Train Acc: 100.00%, Val Loss:   0.43, Val Acc:  92.22%, Time: 0:24:58 *
Iter:  21200, Train Loss:  0.094, Train Acc:  98.44%, Val Loss:   0.46, Val Acc:  91.80%, Time: 0:25:05
Iter:  21300, Train Loss:   0.17, Train Acc:  98.44%, Val Loss:   0.45, Val Acc:  92.25%, Time: 0:25:12 *
Iter:  21400, Train Loss:  0.094, Train Acc:  96.88%, Val Loss:   0.46, Val Acc:  92.18%, Time: 0:25:18
Iter:  21500, Train Loss:  0.029, Train Acc:  98.44%, Val Loss:   0.45, Val Acc:  91.92%, Time: 0:25:25
Iter:  21600, Train Loss:   0.11, Train Acc:  98.44%, Val Loss:   0.44, Val Acc:  92.10%, Time: 0:25:31
Iter:  21700, Train Loss:  0.099, Train Acc:  98.44%, Val Loss:   0.46, Val Acc:  91.93%, Time: 0:25:38
Iter:  21800, Train Loss:  0.069, Train Acc:  98.44%, Val Loss:   0.46, Val Acc:  91.68%, Time: 0:25:45
Iter:  21900, Train Loss:  0.097, Train Acc:  96.88%, Val Loss:   0.46, Val Acc:  91.90%, Time: 0:25:51
Iter:  22000, Train Loss:  0.024, Train Acc:  98.44%, Val Loss:   0.45, Val Acc:  92.13%, Time: 0:25:58
Iter:  22100, Train Loss:   0.01, Train Acc: 100.00%, Val Loss:   0.43, Val Acc:  92.14%, Time: 0:26:05
Iter:  22200, Train Loss:   0.11, Train Acc:  98.44%, Val Loss:   0.43, Val Acc:  92.25%, Time: 0:26:11
Iter:  22300, Train Loss:  0.011, Train Acc: 100.00%, Val Loss:   0.43, Val Acc:  92.21%, Time: 0:26:18
No optimization for a long time, auto-stopping...



在验证集上的最佳效果为92.25%.



### 测试

运行 `python run_cnn.py test` 在测试集上进行测试。

```
Configuring CNN model...
Loading test data...
Testing...
Test Loss:   0.46, Test Acc:  91.85%

在测试集上的准确率达到了91.85%。


### 预测

运行 `python run_cnn.py predict` 在预测集上进行预测。

预测集命名为`name2category.predict.txt`,放入data中的name2category文件夹，每行一个产品名称。

输出在目录文件夹，名称为`predicted_data.txt`

### 功能调用

调用方法为:

```python
from run_cnn import name2subcategory

name_list = ['乔思伯 JONSBO CR-201RGB版本RGBCPU散热器（黑色/多平台/4热管/温控/12CM风扇/支持AURARGB/附硅脂）'] 
a = name2subcategory()
category = a.namelyst_predict(name_list)
```

输入一个含有多个产品名称的列表，返回一个各名称子类的列表。