from public.SimilarCharactor.string_util import string2code,traditional2simplified
from public.SimilarCharactor.edit_distance import minEditDist
import difflib
import Levenshtein

def similarity_cn(string1,string2):
    code_string1 = string2code(traditional2simplified(string1))
    code_string2 = string2code(traditional2simplified(string2))
    
    distance = minEditDist(code_string1,code_string2)
    return 1 - distance/max(len(code_string1),len(code_string2))


def similarity_en(string1,string2):
    
    fraction_part1 = Levenshtein.ratio(string1,string2)
    fraction_part2 =  difflib.SequenceMatcher(None, string1, string2).quick_ratio()

    fraction = fraction_part1*0.5+fraction_part2*0.5
    
    return fraction
