#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Apr  9 23:37:15 2020

@author: rico
"""

import pymssql
import pandas as pd
import os
import requests
import tensorflow as tf
from lxml import etree
import re
import datetime
import json
import time
#from text_moudle.run_cnn import name2subcategory as generl_name2subcategory
#from text_moudle_LXWL.run_cnn import name2subcategory as LXWL_name2subcategory
#print (os.getcwd())


class Index(object):
    def __init__(self, number=50, decimal=2):
        """
        :param decimal: 你保留的保留小数位
        :param number: # 号的 个数
        """
        self.decimal = decimal
        self.number = number
        self.a = 100/number   # 在百分比 为几时增加一个 # 号
 
    def __call__(self, now, total):
        # 1. 获取当前的百分比数
        percentage = self.percentage_number(now, total)
 
        # 2. 根据 现在百分比计算
        well_num = int(percentage / self.a)
        # print("well_num: ", well_num, percentage)
 
        # 3. 打印字符进度条
        progress_bar_num = self.progress_bar(well_num)
 
        # 4. 完成的进度条
        result = "\r%s %s" % (progress_bar_num, percentage)
        return result
 
    def percentage_number(self, now, total):
        """
        计算百分比
        :param now:  现在的数
        :param total:  总数
        :return: 百分
        """
        return round(now / total * 100, self.decimal)
 
    def progress_bar(self, num):
        """
        显示进度条位置
        :param num:  拼接的  “#” 号的
        :return: 返回的结果当前的进度条
        """
        # 1. "#" 号个数
        well_num = "#" * num
 
        # 2. 空格的个数
        space_num = " " * (self.number - num)
 
        return '[%s%s]' % (well_num, space_num)

def match_sku(sku_list,frm):
    '''
    对供应商提供的链接进行排重
    frm : DL/DW/DZ/GM/JD/LXWL/OFS/SN/YHD/ZCSM
    '''
    #sku_list = ['11867713605']
    #frm = 'SN'
    conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database='ZI_NEW',autocommit=True)
    cursor = conn.cursor()
    
    conn_zi_database = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database='ZI_DataBase',autocommit=True)
    cursor_zi_database = conn_zi_database.cursor()
    #print('正在删除库中产品状态为6的sku，稍等。。。')#首先将库中错误状态产品的JD/SN/GM的SKU删除
    #cursor.execute("DELETE from productcode_sku where productcode in (select productcode from info_product where state='6')")
    #print('正在删除库中重复的SKU，稍等。。。')#需先删除库中重复的SKU，避免匹配相同的编码
    '''
    cursor.execute("declare OperCursor Cursor for\
                      SELECT productcode,sku,frm,count(*) ca  FROM productcode_sku\
                    GROUP BY productcode,sku,frm\
                    HAVING COUNT(*)>1\
                      open OperCursor\
                      declare @PRODUCTCODE as nvarchar(20)\
                      declare @sku as nvarchar(50)\
                      declare @frm as nvarchar(20)\
                      declare @ca	  as 	int\
                      declare @return_value	 as int\
                    fetch next from OperCursor into @PRODUCTCODE,@sku,@frm,@ca\
                    IF @@fetch_status=0\
                    delete from productcode_sku\
                            where id  in (select top (@ca-1) id from productcode_sku\
                    where  productcode=@PRODUCTCODE and sku=@sku and frm=@frm)\
                    \
                    while @@fetch_status=0\
                    begin\
                    fetch next from OperCursor into @PRODUCTCODE,@sku,@frm,@ca\
                    IF @@fetch_status=0\
                    delete from productcode_sku\
                    where id  in (select top (@ca-1) id from productcode_sku\
                    where  productcode=@PRODUCTCODE and sku=@sku and frm=@frm)\
                    end\
                    close OperCursor\
                    deallocate OperCursor")
    conn.commit()
    '''
    print('正在获取当前库中所有sku,请稍等.....')#获取库中所有的SKU,以供检查
    try:
        get_all_sku = f"select productcode,sku from Productcode_Sku where frm in {frm} and productcode not like '78%'"
        cursor.execute(get_all_sku)
        data_sku = (cursor.fetchall())
        data_sku_file = pd.DataFrame(data_sku,columns=['productcode','sku'])
    except:
        get_all_sku = f"select productcode,sku from Productcode_Sku where frm='{frm}' and productcode not like '78%'"
        cursor.execute(get_all_sku)
        data_sku = (cursor.fetchall())
        data_sku_file = pd.DataFrame(data_sku,columns=['productcode','sku'])


    #获取op_productcode_sku
    if frm == 'SN':
        frm = 'SN-NEW'
    get_all_sku = f"select productcode,sku from op_product_sku where frm='{frm}' and productcode not like '78%' "
    cursor_zi_database.execute(get_all_sku)
    data_sku = (cursor_zi_database.fetchall())
    data_sku_file_op = pd.DataFrame(data_sku,columns=['productcode','sku'])

    data_sku_file = pd.concat([data_sku_file,data_sku_file_op]).drop_duplicates()
    data_sku_file['productcode'] = data_sku_file['productcode'].apply(lambda x:x.strip())
    data_sku_file['sku'] = data_sku_file['sku'].apply(lambda x:x.strip())

    print('sku获取完毕')
    conn.close()
    cursor.close()
    conn_zi_database.close()
    cursor_zi_database.close()
    
    sku_check = {}
    for sku in set(sku_list):
        sku = sku.strip()
        #print(sku)
        #sku = 100004460761
        if str(sku) in list(data_sku_file['sku']):
            try:
                product_no = [target for sku_source,target in zip(list(data_sku_file['sku']),list(data_sku_file['productcode'])) if str(sku) == sku_source]
                sku_check[f'{sku}'] = product_no[0]
            except:
                sku_check[f'{sku}'] = '2' #匹配上多个SKU，属于问题数据

        else:
            if frm == 'SN' or frm == 'SN-NEW':
                sku_add = '0000000000/'+ str(sku)
                if str(sku_add) in list(data_sku_file['sku']):
                    try:
                        product_no = [target for sku_source,target in zip(list(data_sku_file['sku']),list(data_sku_file['productcode'])) if str(sku_add) == sku_source]
                        sku_check[f'{sku}'] = product_no[0]
                    except:
                        sku_check[f'{sku}'] = '2' #匹配上多个SKU，属于问题数据
                else:
                    sku_check[f'{sku}'] = '0'
            else:
                sku_check[f'{sku}'] = '0'
    return sku_check


def supporturlDataDeal(source,batch):
        '''
        对反爬的数据进行审核排重
        :return:
        '''
        conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database= 'reverse_data',autocommit=True)
        cursor = conn.cursor()
        cursor.execute(f'select * from product where channel_url_validate is Null and 来源={source} and batch={batch}')
        data = (cursor.fetchall())

        df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor.description])[['product_id', 'channel_sku', 'product_name', 'channel_id', 'channel_product_id']]
        df.rename(columns={'product_id': 'id', 'channel_sku': 'sku', 'product_name': 'name', 'channel_id': 'source','channel_product_id': 'url'}, inplace=True)
        df['price'] = '0'

        df_otherDS = df[(df['source'] != 'JD') & (df['source'] != 'GM') & (df['source'] != 'SN')]
        for id_ in df_otherDS['id'].tolist():
            cursor.execute(f"update product set channel_url_validate='通过',zgc_productcode='无' where product_id='{id_}'")

        df_DS = df[(df['source'] == 'JD') | (df['source'] == 'GM') | (df['source'] == 'SN')].reset_index(drop=True)

        # 审核三大电商
        check_data = check_reverse_data(df_DS)
        for id_, suggestion in zip(check_data['update_id'], check_data['审核意见']):
            cursor.execute(f"update product set channel_url_validate='{suggestion}' where product_id='{id_}'")

        # 三大电商SKU与库内排重
        for source in list(df_DS['source'].unique()):
            print(source + 'sku排重中')
            sku_list = df_DS[df_DS['source'] == source]['sku'].tolist()
            sku_check = match_sku(sku_list, source)

            for k, v in sku_check.items():
                if v == '0':
                    cursor.execute(f"update product set zgc_productcode='无' where channel_sku='{k}'")
                else:
                    cursor.execute(f"update product set zgc_productcode='{v}' where channel_sku='{k}'")
            print(source + 'sku排重完毕')
        conn.close()


def check_reverse_data(check_data):
    '''
    审核爬到的数据
    :param check_data: 需要审核的数据
    :return: 审核完毕的数据
    '''
    conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311', password='zgcprice20200628', database='zi_zh',autocommit=True)
    cursor = conn.cursor()
    cursor.execute('select stop_word,white_word from Stopwords')
    data = (cursor.fetchall())
    word_df = pd.DataFrame(data, columns=['stopword', 'whiteword'])

    headers = {'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36'}
    session = requests.Session()
    if check_data.empty:
        print('今日无新增数据')
        return check_data

    print('共' + str(len(check_data)) + '条数据待审核')
    result = []
    id_all = []
    sku_list = []
    name_list = []
    url_list = []
    source_list = []
    price_list = []

    for i in range(len(check_data)):
        df = check_data.loc[i]
        date_id = df['id']
        sku = df['sku']
        name = df['name']
        main_url = df['url'].strip()
        source = df['source']
        price = df['price']
        brand = df['brand']
        subcategory = df['category']
        print(main_url)
        if "jd" in str(main_url):
            try:
                sku = main_url.split('/')[-1].split('.')[0]
                # 获取价格
                url = "https://p.3.cn/prices/mgets?skuIds=" + str(sku)
                r = get_response(session, url, headers).json()
                jd_price = r[0]['p']

                if len(jd_price) == 0:
                    jd_price = price
                if jd_price == '-1.00':
                    jd_price = price
                    price_list.append(jd_price)
                    result.append("无货，请按要求提供在销渠道证明")
                    id_all.append(date_id)
                    sku_list.append(sku)
                    name_list.append(name)
                    url_list.append(main_url)
                    source_list.append(source)
                else:
                    price_list.append(jd_price)
                    # 获取其他信息
                    main_url_ = "https://item.jd.com/" + sku + ".html"
                    r = get_response(session, main_url_, headers)
                    html = etree.HTML(r.text)
                    ziying = html.xpath(
                        "//div[@class='name goodshop EDropdown']/em/text()")
                    if "自营" in str(ziying):
                        name = html.xpath(
                            "//div[@class='sku-name']/text()")

                        flag = False
                        for stopword, whitewords in zip(list(word_df['stopword']), list(word_df['whiteword'])):
                            try:
                                whiteword_list = whitewords.split('/')
                                print(whiteword_list)
                            except:
                                whiteword_list = []
                            for whiteword in whiteword_list:
                                if stopword in str(name) and whiteword not in str(name):
                                    flag = True
                                    break
                        if flag:

                            print("定制/专用/书籍类产品暂不通过")
                            result.append("定制/专用/书籍类产品暂不通过")
                            id_all.append(date_id)
                            sku_list.append(sku)
                            name_list.append(name)
                            url_list.append(main_url)
                            source_list.append(source)
                        else:
                            # 获取库存信息
                            url = "https://c0.3.cn/stock?skuId=" + str(sku) + "&area=1_2901_2906_0&cat=9987,653,655"
                            r = get_response(session, url, headers)
                            if r == -1:
                                print("通过")
                                result.append("通过")
                                id_all.append(date_id)
                                sku_list.append(sku)
                                name_list.append(name)
                                url_list.append(main_url)
                                source_list.append(source)
                            else:
                                r.encoding = 'gbk'
                                is_purchase = json.loads(r.text)
                                try:
                                    if "无货" in is_purchase['stock']['stockDesc'] or "无货" in is_purchase['stock'][
                                        'StockStateName']:
                                        print("无货，请按要求提供在销渠道证明")
                                        result.append("无货，请按要求提供在销渠道证明")
                                        id_all.append(date_id)
                                        sku_list.append(sku)
                                        name_list.append(name)
                                        url_list.append(main_url)
                                        source_list.append(source)
                                    else:
                                        print("通过")
                                        result.append("通过")
                                        id_all.append(date_id)
                                        sku_list.append(sku)
                                        name_list.append(name)
                                        url_list.append(main_url)
                                        source_list.append(source)
                                except:
                                    if "无货" in is_purchase['StockStateName']:
                                        print("无货，请按要求提供在销渠道证明")
                                        result.append("无货，请按要求提供在销渠道证明")
                                        id_all.append(date_id)
                                        sku_list.append(sku)
                                        name_list.append(name)
                                        url_list.append(main_url)
                                        source_list.append(source)
                                    else:
                                        print("通过")
                                        result.append("通过")
                                        id_all.append(date_id)
                                        sku_list.append(sku)
                                        name_list.append(name)
                                        url_list.append(main_url)
                                        source_list.append(source)
                    else:
                        print("非自营，请按要求提供在销渠道证明")
                        result.append("非自营，请按要求提供在销渠道证明")
                        id_all.append(date_id)
                        sku_list.append(sku)
                        name_list.append(name)
                        url_list.append(main_url)
                        source_list.append(source)
            except:
                print("链接有误，请按要求提供在销渠道证明")
                result.append("链接有误，请按要求提供在销渠道证明")
                price_list.append(price)
                id_all.append(date_id)
                sku_list.append(sku)
                name_list.append(name)
                url_list.append(main_url)
                source_list.append(source)

        elif "gome" in str(main_url):
            try:
                main_url_1 = re.findall(".cn/(.*?).html", main_url)[0]
                main_url_ = 'https://item.gome.com.cn/' + main_url_1 + '.html'
                r = get_response(session, main_url_, headers)
                html = etree.HTML(r.text)
                content = html.xpath("//script[contains(text(),'gomePrice')]/text()")[0]
                gm_price = content.split('gomePrice:"')[1:][0].split('"')[0]
                price_list.append(gm_price)

                ziying = html.xpath(
                    "//span[@class='identify']/text()")
                if len(ziying) == 1:
                    name = html.xpath(
                        "//*[@id='gm-prd-main']/div[1]/h1/text()")
                    flag = False
                    for stopword, whitewords in zip(list(word_df['stopword']), list(word_df['whiteword'])):
                        try:
                            whiteword_list = whitewords.split('/')
                            print(whiteword_list)
                        except:
                            whiteword_list = []
                        for whiteword in whiteword_list:
                            if stopword in str(name) and whiteword not in str(name):
                                flag = True
                                break
                    if flag:
                        print("定制/专用/书籍类产品暂不通过")
                        result.append("定制/专用/书籍类产品暂不通过")
                        id_all.append(date_id)
                        sku_list.append(sku)
                        name_list.append(name)
                        url_list.append(main_url)
                        source_list.append(source)
                    else:
                        # 获取库存信息
                        sku = main_url_.split('.html')[0].split('/')[-1].replace('-', '/')
                        url = "https://ss.gome.com.cn/item/v1/d/m/store/unite/" + str(
                            sku) + "/N/11010200/110102002/1/null/flag/item/allStores?callback=allStores"
                        r = get_response(session, url, headers)
                        content = r.text.replace('allStores(', '')
                        content = content.replace(')', '')
                        content = json.loads(content)
                        wuhuo = content['result']['stock']['status']
                        if wuhuo == False:
                            print("无货，请按要求提供在销渠道证明")
                            result.append("无货，请按要求提供在销渠道证明")
                            id_all.append(date_id)
                            sku_list.append(sku)
                            name_list.append(name)
                            url_list.append(main_url)
                            source_list.append(source)
                        else:
                            print("通过")
                            result.append("通过")
                            id_all.append(date_id)
                            sku_list.append(sku)
                            name_list.append(name)
                            url_list.append(main_url)
                            source_list.append(source)
                else:
                    print("非自营，请按要求提供在销渠道证明")
                    result.append("非自营，请按要求提供在销渠道证明")
                    id_all.append(date_id)
                    sku_list.append(sku)
                    name_list.append(name)
                    url_list.append(main_url)
                    source_list.append(source)
            except:
                print("链接有误，请按要求提供在销渠道证明")
                result.append("链接有误，请按要求提供在销渠道证明")
                price_list.append(price)
                id_all.append(date_id)
                sku_list.append(sku)
                name_list.append(name)
                url_list.append(main_url)
                source_list.append(source)

        elif "suning" in str(main_url):
            try:
                # main_url = 'http://product.suning.com/0000000000/10643583782.html'
                sku = re.findall(".com/(.*?).html", main_url)[0]
                main_url_ = 'https://product.suning.com/' + sku + '.html'
                r = get_response(session, main_url_, headers)
                html = etree.HTML(r.text)
                daaa = r.text
                sn_price = price
                str2 = html.xpath("//input[@id='curPartNumber']/@value")[0]
                ziying1 = html.xpath("//div[@class='proinfo-title']/h1/span/i/text()")
                ziying2 = html.xpath("//h1[@id='itemDisplayName']/span/text()")
                youhuo_ = re.findall("id=\"ie7_onsale\" >(.*?)<i", daaa)

                if "自营" in ziying1 or "自营" in ziying2:
                    url_json = f'https://product.suning.com/pds-web/ajax/itemUniqueInfo_{str(str2)}_0000000000.html'
                    response_json = get_response(session, url_json, headers)
                    json_data = json.loads(response_json.text)
                    itemDetail = json_data["itemDetail"]
                    try:
                        isPublished = itemDetail["isPublished"]
                    except:
                        isPublished = '0'
                    name = itemDetail["cmmdtyTitle"]
                    if isPublished == '1':
                        if '此款有货' in str(youhuo_):
                            flag = False
                            for stopword, whitewords in zip(list(word_df['stopword']), list(word_df['whiteword'])):
                                try:
                                    whiteword_list = whitewords.split('/')
                                    print(whiteword_list)
                                except:
                                    whiteword_list = []
                                for whiteword in whiteword_list:
                                    if stopword in str(name) and whiteword not in str(name):
                                        flag = True
                                        break
                            if flag:
                                print("定制/专用/书籍类产品暂不通过")
                                result.append("定制/专用/书籍类产品暂不通过")
                                price_list.append(sn_price)
                                id_all.append(date_id)
                                sku_list.append(sku)
                                name_list.append(name)
                                url_list.append(main_url)
                                source_list.append(source)
                            else:

                                str_price = html.xpath("//a[@id='addCart2']/@sa-data")
                                str1 = re.findall("'prdid':'(.*?)','", str(str_price))[0]  # 为了拼接所需要的url，需要三个字段
                                str2 = re.findall("'shopid':'(.*?)','", str(str_price))[0]  # 为了拼接所需要的url，需要三个字段
                                str3 = html.xpath("//input[@name='procateCode']/@value")[0]  # 为了拼接所需要的url，需要三个字段
                                real_url = f'https://pas.suning.com/nspcsale_0_{str1}_{str1}_{str2}_10_010_0100100_157122_1000000_9017_10106_Z001___{str3}.html?callback=pcData'
                                try:
                                    price_response = requests.get(real_url, timeout=5)
                                    sn_price = re.findall('"promotionPrice":"(.*?)",', price_response.text)[0]
                                except:
                                    sn_price = price
                                if len(sn_price) != 0:
                                    price_list.append(sn_price)
                                    print('通过')
                                    result.append('通过')
                                    id_all.append(date_id)
                                    sku_list.append(sku)
                                    name_list.append(name)
                                    url_list.append(main_url)
                                    source_list.append(source)
                                else:
                                    sn_price = price
                                    price_list.append(sn_price)
                                    print('该地区不销售（北京市丰台区）')
                                    result.append('该地区不销售（北京市丰台区）')
                                    id_all.append(date_id)
                                    sku_list.append(sku)
                                    name_list.append(name)
                                    url_list.append(main_url)
                                    source_list.append(source)

                                '''
                                str11 = html.xpath("//input[@id='curPartNumber']/@value")[0]
                                str22 = html.xpath("//input[@id='shop_code']/@value")[0]
                                str33 = html.xpath("//input[@name='procateCode']/@value")[0]
                                real_url = f'https://pas.suning.com/nspcsale_0_{str11}_{str11}_{str22}_10_010_0100100_157122_1000000_9017_10106_Z001___{str33}.html?callback=pcData'
                                price_response = requests.get(real_url)
                                sn_price = re.findall('"promotionPrice":"(.*?)",', price_response.text)[0]

                                #if len(sn_price) != 0:
                                price_list.append(sn_price)
                                print('通过')
                                result. append('通过')
                                id_all.append(date_id)
                                sku_list.append(sku)
                                name_list.append(name)
                                url_list.append(main_url)
                                source_list.append(source)

                                else:
                                    sn_price = price
                                    price_list.append(sn_price)
                                    print('该地区不销售（北京市丰台区）')
                                    result. append('该地区不销售（北京市丰台区）')
                                    id_all.append(date_id)
                                    sku_list.append(sku)
                                    name_list.append(name)
                                    url_list.append(main_url)
                                    source_list.append(source)
                                '''

                        else:
                            print('无货，请按要求提供在销渠道证明')
                            sn_price = price
                            result.append('无货，请按要求提供在销渠道证明')
                            price_list.append(sn_price)
                            id_all.append(date_id)
                            sku_list.append(sku)
                            name_list.append(name)
                            url_list.append(main_url)
                            source_list.append(source)

                    else:
                        print('无货，请按要求提供在销渠道证明')
                        sn_price = price
                        result.append('无货，请按要求提供在销渠道证明')
                        price_list.append(sn_price)
                        id_all.append(date_id)
                        sku_list.append(sku)
                        name_list.append(name)
                        url_list.append(main_url)
                        source_list.append(source)
                else:
                    print('非自营，请按要求提供在销渠道证明')
                    result.append('非自营，请按要求提供在销渠道证明')
                    price_list.append(price)
                    id_all.append(date_id)
                    sku_list.append(sku)
                    name_list.append(name)
                    url_list.append(main_url)
                    source_list.append(source)
            except:
                print("链接有误，请按要求提供在销渠道证明")
                result.append("链接有误，请按要求提供在销渠道证明")
                price_list.append(price)
                id_all.append(date_id)
                sku_list.append(sku)
                name_list.append(name)
                url_list.append(main_url)
                source_list.append(source)

        else:
            print("非三大电商，请按要求提供在销渠道证明")
            result.append("非三大电商，请按要求提供在销渠道证明")
            price_list.append(price)
            id_all.append(date_id)
            sku_list.append(sku)
            name_list.append(name)
            url_list.append(main_url)
            source_list.append(source)

        print(f"已经处理{i + 1}条数据")

    check_data['审核意见'] = result
    check_data['update_id'] = id_all
    check_data['sku'] = sku_list
    check_data['name'] = name_list
    check_data['url'] = url_list
    check_data['source'] = source_list
    check_data['price'] = price_list

    conn.close()
    return check_data



def get_response(session, url, headers):
        '''
        deal timeout request
        '''
        network_status = True
        try:
            response = session.get(url, headers=headers, timeout=5)
            if response.status_code == 200:
                return response
        except:
            network_status = False
            if network_status == False:
                '''timeout'''
                for i in range(1, 10):
                    print('请求超时，第%s次重复请求' % i)
                    try:
                        response = session.get(url, headers=headers, timeout=5)
                        if response.status_code == 200:
                            return response
                    except:
                        continue
        return -1


def check_data(fileName,source):
    
    conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311', password='zgcprice20200628', database='zi_zh',autocommit=True)
    cursor = conn.cursor()

    reverse_conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311', password='zgcprice20200628', database='reverse_data',autocommit=True)
    reverse_cursor = reverse_conn.cursor()

    result = []
    price = []
    headers = {
        'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36'}
    session = requests.Session()

    cursor.execute("select stop_word,white_word from stopwords")
    stopwords = (cursor.fetchall())
    word_list = pd.DataFrame(stopwords, columns=['stopword', 'white_word'])

    #获取需要审核的政采的供应商的id
    #cursor.execute("select id from users where frm is not null and frm != ''")
    #need_check_id_from_zc = [i[0] for i in cursor.fetchall()]


    # 审核链接
    for i in range(len(fileName)):
        df = fileName.loc[i]
        if 'otherurl' in df.index.tolist():
            if df['otherurl']:
                try:
                    otherurl = eval(df['otherurl'])[0].strip()
                except:
                    otherurl = df['otherurl'].strip()
            else:
                otherurl = ''
            
        elif 'supporturl' in df.index.tolist():
            other = eval(df['supporturl'].strip())
            #other = df['supporturl'].strip()
            if isinstance(other,list) and len(other) != 0:
                otherurl = other[0]
            else:
                otherurl = other
        else:
            otherurl = ''
            print('该渠道为API流程中的没有提供其他链接的渠道，其product_all表既没有other字段，也没有supporturl字段')
        
        if df['url']:  
            try:
                main_url = eval(df['url'])[0].strip()
            except:
                main_url = df['url'].strip()
        else:
            main_url = otherurl

        if "jd" not in str(main_url) and "gome" not in str(main_url) and "suning" not in str(main_url):
            main_url = otherurl

        # if len(main_url) == 0 and len(otherurl) != 0:
        #     main_url = otherurl

        print(f'开始处理：{main_url}')

        if len(main_url) == 0:
            print("其他销售渠道证明")
            result.append("其他销售渠道证明")
            price.append("其他销售渠道价格")

        elif "jd" in str(main_url) or "gome" in str(main_url) or "suning" in str(main_url):

            if "jd" in str(main_url):
                if "i-item" in str(main_url):
                    jd_price = df['price']
                    price.append(jd_price)
                    result.append("通过")
                else:
                    
                    try:
                        try_ = session.get(main_url, headers=headers)
                        sku = main_url.split('/')[-1].split('.')[0]
                        # 获取价格
                        url = "https://p.3.cn/prices/mgets?skuIds=" + str(sku)
                        r = session.get(url, headers=headers).json()
                        jd_price = r[0]['p']
    
                        if len(jd_price) == 0:
                            print('未获取到价格，使用供应商提交价格！！！')
                            jd_price = df['price']
                        if jd_price == '-1.00':
                            jd_price = df['price']
                            price.append(jd_price)
                            result.append("无货，请按要求提供在销渠道证明")
                        else:
                            print('价格为:', jd_price)
    
                            # 获取其他信息
                            main_url_ = "https://item.jd.com/" + sku + ".html"
                            r = session.get(main_url_, headers=headers)
                            html = etree.HTML(r.text)
                            ziying = html.xpath(
                                "//div[@class='name goodshop EDropdown']/em/text()")
                            if "自营" in str(ziying):
                                name = html.xpath("//div[@class='sku-name']/text()")
                                # if ("定制"in str(name)) or ("防弹"in str(name)) or ("射击"in str(name)) or
                                # ("订制"in str(name)) or ("卫星"in str(name)) or ("靶"in str(name)) or ("企业定制"in str(name))
                                # or ("军迷"in str(name)) or ("携行具"in str(name)) or ("酒"in str(name)  and "酒精" not in str(name))
                                # or ("军用" in str(name)) or ("作战" in str(name)) or ("部队" in str(name)) or ("迷彩" in str(name))
                                # or ("军队" in str(name)) or ("陆军" in str(name)) or ("海军" in str(name)) or ("空军" in str(name))
                                # or ("火箭军" in str(name)) or ("涉密" in str(name)) or ("保密" in str(name)) or ("补给单元" in str(name))
                                # or ("书籍" in str(name)) or ("出版物" in str(name)) or ("地图" in str(name)):
                                # name = "地图"
                                pass_word_jd = '即将判断'
                                for sw, ww in zip(list(word_list['stopword']), list(word_list['white_word'])):
                                    if ww is None:
                                        if str(sw) in str(name):
                                            pass_word_jd = '不通过'
                                            print("定制/专用/含禁止上架关键词，产品暂不通过")
                                            result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                            break
                                        else:
                                            pass_word_jd = '暂通过'
                                    else:
                                        if str(sw) in str(name):
                                            if str(ww) in str(name):
                                                pass_word_jd = '暂通过'
                                            else:
                                                pass_word_jd = '不通过'
                                                print("定制/专用/含禁止上架关键词，产品暂不通过")
                                                result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                                break
                                        else:
                                            pass_word_jd = '暂通过'
    
                                if pass_word_jd == '暂通过':
                                    # 获取库存信息
                                    url = "https://c0.3.cn/stock?skuId=" + str(
                                        sku) + "&area=1_2901_2906_0&cat=9987,653,655"
                                    r = get_response(session, url, headers)
                                    if r == -1:
                                        print("通过")
                                        result.append("通过")
                                    else:
                                        r.encoding = 'gbk'
                                        is_purchase = json.loads(r.text)
                                        try:
                                            if "无货" in is_purchase['stock']['stockDesc'] or "无货" in \
                                                    is_purchase['stock']['StockStateName']:
                                                print("无货，请按要求提供在销渠道证明")
                                                result.append("无货，请按要求提供在销渠道证明")
                                            else:
                                                print("通过")
                                                result.append("通过")
                                        except:
                                            if "无货" in is_purchase['StockStateName']:
                                                print("无货，请按要求提供在销渠道证明")
                                                result.append("无货，请按要求提供在销渠道证明")
                                            else:
                                                print("通过")
                                                result.append("通过")
                                else:
                                    pass
                            else:
                                print("非自营，请按要求提供在销渠道证明")
                                result.append("非自营，请按要求提供在销渠道证明")
                            price.append(jd_price)
                    except:
                        print("链接有误，请按要求提供在销渠道证明")
                        result.append("链接有误，请按要求提供在销渠道证明")
                        price.append(df['price'])

            elif "gome" in str(main_url):
                # 获取价格
                try:
                    try_ = session.get(main_url, headers=headers)
                    main_url_1 = re.findall(".cn/(.*?).html", main_url)[0]
                    main_url_ = 'https://item.gome.com.cn/' + main_url_1 + '.html'
                    r = session.get(main_url_, headers=headers)
                    html = etree.HTML(r.text)
                    content = html.xpath("//script[contains(text(),'gomePrice')]/text()")[0]
                    gm_price = content.split('gomePrice:"')[1:][0].split('"')[0]

                    ziying = html.xpath(
                        "//span[@class='identify']/text()")
                    if len(ziying) == 1:
                        name = html.xpath(
                            "//*[@id='gm-prd-main']/div[1]/h1/text()")
                        # if ("定制"in str(name)) or ("防弹"in str(name)) or ("射击"in str(name)) or ("订制"in str(name)) or ("卫星"in str(name)) or ("靶"in str(name)) or ("企业定制"in str(name)) or ("酒"in str(name)  and "酒精" not in str(name)) or ("军用" in str(name)) or ("作战" in str(name)) or ("部队" in str(name)) or ("迷彩" in str(name)) or ("军队" in str(name)) or ("陆军" in str(name)) or ("海军" in str(name)) or ("空军" in str(name)) or ("火箭军" in str(name)) or ("涉密" in str(name)) or ("保密" in str(name)) or ("补给单元" in str(name)) or ("书籍" in str(name)) or ("出版物" in str(name)) or ("地图" in str(name)):
                        pass_word_gm = '即将判断'
                        for sw, ww in zip(list(word_list['stopword']), list(word_list['white_word'])):
                            # print (sw,ww)
                            if ww is None:
                                if str(sw) in str(name):
                                    pass_word_gm = '不通过'
                                    print("定制/专用/含禁止上架关键词，产品暂不通过")
                                    result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                    break
                                else:
                                    pass_word_gm = '暂通过'
                            else:
                                if str(sw) in str(name):
                                    if str(ww) in str(name):
                                        pass_word_gm = '暂通过'
                                    else:
                                        pass_word_gm = '不通过'
                                        print("定制/专用/含禁止上架关键词，产品暂不通过")
                                        result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                        break
                                else:
                                    pass_word_gm = '暂通过'

                        if pass_word_gm == '暂通过':

                            # print("定制/专用/含禁止上架关键词，产品暂不通过")
                            # result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                            # else:
                            # 获取库存信息
                            sku = main_url_.split('.html')[0].split('/')[-1].replace('-', '/')
                            url = "https://ss.gome.com.cn/item/v1/d/m/store/unite/" + str(
                                sku) + "/N/11010200/110102002/1/null/flag/item/allStores?callback=allStores"
                            r = session.get(url, headers=headers)
                            content = r.text.replace('allStores(', '')
                            content = content.replace(')', '')
                            content = json.loads(content)
                            wuhuo = content['result']['stock']['status']
                            if wuhuo == False:
                                print("无货，请按要求提供在销渠道证明")
                                result.append("无货，请按要求提供在销渠道证明")
                            else:
                                print("通过")
                                result.append("通过")
                        else:
                            pass
                    else:
                        print("非自营，请按要求提供在销渠道证明")
                        result.append("非自营，请按要求提供在销渠道证明")
                    price.append(gm_price)
                except:
                    print("链接有误，请按要求提供在销渠道证明")
                    result.append("链接有误，请按要求提供在销渠道证明")
                    price.append(df['price'])

            elif "suning" in str(main_url):
                # sku = main_url.split('.html')[0].split('/')[-1].replace('-','/')
                # main_url = 'https://product.suning.com/0000000000/11768660427.html?safp=d488778a.13701.productWrap.2&safc=prd.3.ssdsn_pic01-1_jz'
                print(f'苏宁：{main_url}')
                try:
                    try_ = session.get(main_url, headers=headers)
                    sku = re.findall(".com/(.*?).html", main_url)[0]
                    main_url_ = 'https://product.suning.com/' + sku + '.html'
                    r = session.get(main_url_, headers=headers)
                    html = etree.HTML(r.text)
                    daaa = r.text
                    sn_price = df.price
                    # sn_price = '58.00-558.00'
                    str2 = html.xpath("//input[@id='curPartNumber']/@value")[0]
                    ziying1 = html.xpath("//div[@class='proinfo-title']/h1/span/i/text()")
                    ziying2 = html.xpath("//h1[@id='itemDisplayName']/span/text()")
                    youhuo_ = re.findall("id=\"ie7_onsale\" >(.*?)<i", daaa)
                    if "自营" in ziying1 or "自营" in ziying2:
                        daohuo = html.xpath("//a[@id='tellMe']/span/text()")
                        url_json = f'https://product.suning.com/pds-web/ajax/itemUniqueInfo_{str(str2)}_0000000000.html'
                        response_json = session.get(url_json, headers=headers)
                        json_data = json.loads(response_json.text)
                        itemDetail = json_data["itemDetail"]
                        try:
                            isPublished = itemDetail["isPublished"]
                        except:
                            isPublished = '0'
                        name = itemDetail["cmmdtyTitle"]
                        if isPublished == '1' or isPublished == '0':
                            if '此款有货' in str(youhuo_):
                                state = '有货'
                                # if ("定制"in str(product_name)) or ("防弹"in str(product_name)) or ("射击"in str(product_name)) \
                                # or ("订制"in str(product_name)) or ("卫星"in str(product_name)) \
                                # or ("靶"in str(product_name)) or ("企业定制"in str(product_name)) \
                                # or ("军迷"in str(product_name)) or ("携行具"in str(product_name)) or ("酒"in str(product_name)  and "酒精" not in str(product_name)) or ("军用" in str(product_name)) or ("作战" in str(product_name)) or ("部队" in str(product_name)) or ("迷彩" in str(product_name)) or ("军队" in str(product_name)) or ("陆军" in str(product_name)) or ("海军" in str(product_name)) or ("空军" in str(product_name)) or ("火箭军" in str(product_name)) or ("涉密" in str(product_name)) or ("保密" in str(product_name)) or ("补给单元" in str(product_name)) or ("书籍" in str(product_name)) or ("出版物" in str(product_name)) or ("地图" in str(product_name)):
                                # result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                # price.append(sn_price)
                                pass_word_sn = '即将判断'
                                for sw, ww in zip(list(word_list['stopword']), list(word_list['white_word'])):
                                    # print (sw,ww)
                                    if ww is None:
                                        if str(sw) in str(name):
                                            pass_word_sn = '不通过'
                                            print("定制/专用/含禁止上架关键词，产品暂不通过")
                                            #result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                            break
                                        else:
                                            pass_word_sn = '暂通过'
                                    else:
                                        if str(sw) in str(name):
                                            if str(ww) in str(name):
                                                pass_word_sn = '暂通过'
                                            else:
                                                pass_word_sn = '不通过'
                                                print("定制/专用/含禁止上架关键词，产品暂不通过")
                                                #result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                                break
                                        else:
                                            pass_word_sn = '暂通过'

                                if pass_word_sn == '暂通过':
                                    # else:
                                    str11 = html.xpath("//input[@id='curPartNumber']/@value")[0]
                                    str22 = html.xpath("//input[@id='shop_code']/@value")[0]
                                    str33 = html.xpath("//input[@name='procateCode']/@value")[0]
                                    if len(str22) == 0:
                                        str22 = '0000000000'
                                        real_url = f'https://pas.suning.com/nspcsale_0_{str11}_{str11}_0000000000_10_010_0100100_501126_1000000_9017_10106_Z001___{str33}_1.0_0___000321NJB____0__.html?callback=pcData'
                                        # real_url = f'https://pas.suning.com/nspcsale_0_{str11}_{str11}_{str22}_10_010_0100100_157122_1000000_9017_10106_Z001___{str33}.html?callback=pcData'
                                        price_response = requests.get(real_url)
                                        sn_price = re.findall('"refPrice":"(.*?)",', price_response.text)[0]
                                        if len(sn_price) == 0:
                                            sn_price = re.findall('"promotionPrice":"(.*?)",', price_response.text)[0]
                                        else:
                                            pass
                                    else:
                                        real_url = f'https://pas.suning.com/nspcsale_0_{str11}_{str11}_{str22}_10_010_0100100_157122_1000000_9017_10106_Z001___{str33}.html?callback=pcData'
                                        price_response = requests.get(real_url)
                                        sn_price = re.findall('"promotionPrice":"(.*?)",', price_response.text)[0]

                                    if len(sn_price) != 0:
                                        try:
                                            sn_price = float(sn_price)
                                            price.append(sn_price)
                                            result.append('通过')
                                        except:
                                            print(f'该链接获取的价格有问题：{sn_price}，{main_url_}')
                                            sn_price = df.price
                                            result.append('该链接无法定位到唯一商品')
                                            if len(sn_price) != 0:
                                                price.append(sn_price)
                                            else:
                                                price.append('0')


                                    else:
                                        sn_price = df.price
                                        result.append('该链接无法定位到唯一商品')
                                        if len(sn_price) != 0:
                                            price.append(sn_price)
                                        else:
                                            price.append('0')
                                else:
                                    result.append('定制/专用/含禁止上架关键词，产品暂不通过')
                                    price.append(sn_price)

                            else:
                                state = '无货，请按要求提供在销渠道证明'
                                sn_price = df.price
                                result.append('无货，请按要求提供在销渠道证明')
                                price.append(sn_price)

                        else:
                            state = "无货，请按要求提供在销渠道证明"
                            # sn_price = df.price
                            result.append('无货，请按要求提供在销渠道证明')
                            price.append(sn_price)
                    else:
                        result.append('非自营，请按要求提供在销渠道证明')
                        price.append(df['price'])
                except:
                    print("链接有误，请按要求提供在销渠道证明")
                    result.append("链接有误，请按要求提供在销渠道证明")
                    price.append(df['price'])


            else:
                print("非自营，请按要求提供在销渠道证明")
                result.append("非自营，请按要求提供在销渠道证明")
                price.append(df['price'])


        else:
            #系统申请的、非三大电商的、有供应商的需要判断停用词
            if 'otherurl' in df.index.tolist():
                #main_url = "http://shanxi.gpmart.cn/productInfo/3300947.html"
                # 去reverse_data获取对应id的产品名称和价格
                print(main_url)
                try:
                    reverse_cursor.execute(f"select a.product_name,b.price from product a left join product_price b on a.product_id=b.product_id where a.id='{df['id']}' and  CHARINDEX(a.channel_product_id,'{main_url}')>0")
                    name_price = reverse_cursor.fetchone()
                    name = name_price[0]
                    price_ = name_price[1]
                except:
                    reverse_cursor.execute(f"select a.product_name,b.price from product a left join product_price b on a.product_id=b.product_id where a.id='{df['id']}'")
                    name_price = reverse_cursor.fetchone()
                    name = name_price[0]
                    price_ = name_price[1]

                pass_word_zc = '即将判断'
                for sw, ww in zip(list(word_list['stopword']), list(word_list['white_word'])):
                    if ww is None:
                        if str(sw) in str(name):
                            pass_word_zc = '不通过'
                            print("定制/专用/含禁止上架关键词，产品暂不通过")
                            result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                            break
                        else:
                            pass_word_zc = '暂通过'
                    else:
                        if str(sw) in str(name):
                            if str(ww) in str(name):
                                pass_word_zc = '通过'
                                result.append("通过")
                                break
                            else:
                                print("定制/专用/含禁止上架关键词，产品暂不通过")
                                result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                pass_word_zc = '不通过'
                                break
                        else:
                            pass_word_zc = '暂通过'
                if pass_word_zc == '暂通过':
                    result.append("通过")
                price.append(price_)


            else:
                # 非系统申请、非三大电商
                # 去reverse_data获取对应id的产品名称和价格
                reverse_cursor.execute(f"select a.product_name,b.price from product a left join product_price b on a.product_id=b.product_id where a.id='{df['sku']}' and CHARINDEX(a.channel_product_id,'{main_url}')>0")
                name_price = reverse_cursor.fetchone()
                if name_price:
                    print(f'name_price：{name_price},价格：{str(name_price[1])}')
                    name = name_price[0]
                    price_ = str(name_price[1])
                    pass_word_zc = '即将判断'
                    for sw, ww in zip(list(word_list['stopword']), list(word_list['white_word'])):
                        if ww is None:
                            if str(sw) in str(name):
                                pass_word_zc = '不通过'
                                print("定制/专用/含禁止上架关键词，产品暂不通过")
                                result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                break
                            else:
                                pass_word_zc = '暂通过'
                        else:
                            if str(sw) in str(name):
                                if str(ww) in str(name):
                                    pass_word_zc = '通过'
                                    result.append("通过")
                                    break
                                else:
                                    print("定制/专用/含禁止上架关键词，产品暂不通过")
                                    result.append("定制/专用/含禁止上架关键词，产品暂不通过")
                                    pass_word_zc = '不通过'
                                    break
                            else:
                                pass_word_zc = '暂通过'
                    if pass_word_zc == '暂通过':
                        result.append("通过")
                    price.append(price_)
                else:
                    result.append("非自营，请按要求提供在销渠道证明")
                    price.append(df['price'])

        print(f"已经处理{i + 1}条数据\n")
        
        if len(result)!=len(price):
            
            print("问题链接：",main_url)
            break

    

    print(f'审核意见：{len(result)}')
    print(f'price：{len(price)}')
    print(f'总条数：{len(fileName)}')

    fileName['审核意见'] = result
    fileName['price'] = price


    urlss_all = []
    for i in range(len(fileName)):
        dw = fileName.loc[i]
        
        if dw.url:
            url_u = dw.url.strip()
    
            if len(url_u) == 0:
                pass
    
            elif "jd" in str(url_u) or "gome" in str(url_u) or "suning" in str(url_u):
                print(url_u)
                try:
                    if "jd" in str(url_u):
                        skuu = url_u.split('/')[-1].split('.')[0]
                    elif "suning" in str(url_u):
                        skuu = re.findall(".com/(.*?).html", url_u)[0]
                    elif "gome" in str(url_u):
                        skuu = re.findall(".cn/(.*?).html", url_u)[0]
    
                    # print(skuu)
    
                    if str(skuu) in urlss_all:
                        fileName.loc[i, '审核意见'] = '该链接与其他供应商提供链接重复，暂定不通过，正在处理，请稍等'
                    else:
                        urlss_all.append(skuu)
                except:
                    fileName.loc[i, '审核意见'] = '链接有误，请按要求提供在销渠道证明'
            else:
                pass

    print('更新状态中。。。')
    id_pass = []
    id_nopass = []
    id_nojd = []
    id_noname = []
    id_qita = []
    id_sku = []
    id_buxiaoshou = []
    id_ljcw = []

    id_suning = []
    id_cfcf = []
    id_noding = []

    

        # elif suggestion == '苏宁产品链接略过，人工审核':
        # id_suning.append(id_name)
        # elif sugestion == '已在库中':
        #   id_sku.append(id_name)
    if source == 'zi_zh':
        
        today = datetime.datetime.now().strftime("%Y/%m/%d %H:%M:%S")
        for id_name, suggestion in zip(fileName['product_zh_id'], fileName['审核意见']):
            if suggestion == '通过':
                id_pass.append(id_name)
            elif suggestion == '无货，请按要求提供在销渠道证明':
                id_nopass.append(id_name)
            elif suggestion == '非自营，请按要求提供在销渠道证明':
                id_nojd.append(id_name)
            elif suggestion == '定制/专用/含禁止上架关键词，产品暂不通过':
                id_noname.append(id_name)
            elif suggestion == '该链接无法定位到最终产品，存在多个价格':
                id_buxiaoshou.append(id_name)
            elif suggestion == '链接有误，请按要求提供在销渠道证明':
                id_ljcw.append(id_name)
            elif suggestion == '其他销售渠道证明':
                id_qita.append(id_name)
            elif suggestion == '该链接与其他供应商提供链接重复，暂定不通过，正在处理，请稍等':
                id_cfcf.append(id_name)
            elif suggestion == '该链接无法定位到唯一商品':
                id_noding.append(id_name)
        
        #for id_, price_ in zip(fileName['product_zh_id'], fileName['price']):
            #cursor.execute(f"update product_zh set price='{price_}' where id='{id_}'")
            #cursor.execute(f"update product_all set price='{price_}' where product_zh_id='{id_}'")

        print('更新数据库～')
        for id_num in id_pass:
            cursor.execute(f"update product_zh set state='1' where id= '{id_num}'")
            cursor.execute(f"update product_all set state='1' where product_zh_id= '{id_num}'")
            conn.commit()
        for i in id_nopass:
            cursor.execute(f"update product_zh set state='2',remark='无货，请按要求提供在销渠道证明',isdo='1' where id='{i}'")
            cursor.execute(f"update product_all set state='2',remark='无货，请按要求提供在销渠道证明' where product_zh_id='{i}'")
            conn.commit()
        for i in id_nojd:
            cursor.execute(f"update product_zh set state='2',remark='非自营，请按要求提供在销渠道证明',isdo='1' where id='{i}'")
            cursor.execute(f"update product_all set state='2',remark='非自营，请按要求提供在销渠道证明' where product_zh_id='{i}'")
            conn.commit()
        for i in id_noname:
            cursor.execute(f"update product_zh set state='1',remark='定制/专用/含禁止上架关键词，产品暂不通过' where id='{i}'")
            cursor.execute(f"update product_all set state='2',remark='定制/专用/含禁止上架关键词，产品暂不通过' where product_zh_id='{i}'")
            conn.commit()
        #for i_price, i_id in zip(price, fileName['product_zh_id']):
            #cursor.execute(f"update product_zh set price='{i_price}' where id='{i_id}'")
            #cursor.execute(f"update product_all set price='{i_price}' where product_zh_id='{i_id}'")
            #conn.commit()
        for i in id_buxiaoshou:
            cursor.execute(f"update product_zh set state='1',remark='该链接无法定位到最终产品，存在多个价格' where id='{i}'")
            cursor.execute(f"update product_all set state='2',remark='该链接无法定位到最终产品，存在多个价格' where product_zh_id='{i}'")
            conn.commit()
        for i in id_ljcw:
            cursor.execute(f"update product_zh set state='1',remark='链接有误，请按要求提供在销渠道证明' where id='{i}'")
            cursor.execute(f"update product_all set state='2',remark='链接有误，请按要求提供在销渠道证明' where product_zh_id='{i}'")
            conn.commit()
        for i in id_qita:
            cursor.execute(f"update product_zh set state='1',remark='其他销售渠道证明，需人工审核' where id='{i}'")
            cursor.execute(f"update product_all set state='2',remark='其他销售渠道证明，需人工审核' where product_zh_id='{i}'")
            conn.commit()
        for i in id_cfcf:
            cursor.execute(f"update product_zh set state='2',remark='该链接与其他供应商提供链接重复，暂定不通过，正在处理，请稍等' where id='{i}'")
            cursor.execute(f"update product_all set state='2',remark='该链接与其他供应商提供链接重复，暂定不通过，正在处理，请稍等' where product_zh_id='{i}'")
            conn.commit()
        for i in id_noding:
            cursor.execute(f"update product_zh set state='1',remark='该链接无法定位到唯一商品' where id='{i}'")
            cursor.execute(f"update product_all set state='2',remark='该链接无法定位到唯一商品' where product_zh_id='{i}'")
            conn.commit()

    else:
        
        today = datetime.datetime.now().strftime("%Y/%m/%d %H:%M:%S")
        for id_name, suggestion in zip(fileName['id'], fileName['审核意见']):
            if suggestion == '通过':
                id_pass.append(id_name)
            elif suggestion == '无货，请按要求提供在销渠道证明':
                id_nopass.append(id_name)
            elif suggestion == '非自营，请按要求提供在销渠道证明':
                id_nojd.append(id_name)
            elif suggestion == '定制/专用/含禁止上架关键词，产品暂不通过':
                id_noname.append(id_name)
            elif suggestion == '该链接无法定位到最终产品，存在多个价格':
                id_buxiaoshou.append(id_name)
            elif suggestion == '链接有误，请按要求提供在销渠道证明':
                id_ljcw.append(id_name)
            elif suggestion == '其他销售渠道证明':
                id_qita.append(id_name)
            elif suggestion == '该链接与其他供应商提供链接重复，暂定不通过，正在处理，请稍等':
                id_cfcf.append(id_name)
            elif suggestion == '该链接无法定位到唯一商品':
                id_noding.append(id_name)
        
        #for id_, price_ in zip(fileName['product_zh_id'], fileName['price']):
            #cursor.execute(f"update product_zh set price='{price_}' where id='{id_}'")
            #cursor.execute(f"update product_all set price='{price_}' where product_zh_id='{id_}'")

        print('更新数据库～')
        for id_num in id_pass:
            cursor.execute(f"update product_all_api set state='1' where id= '{id_num}'")
            conn.commit()
        for i in id_nopass:
            cursor.execute(f"update product_all_api set state='2',remark='无货，请按要求提供在销渠道证明' where id='{i}'")
            conn.commit()
        for i in id_nojd:
            cursor.execute(f"update product_all_api set state='2',remark='非自营，请按要求提供在销渠道证明' where id='{i}'")
            conn.commit()
        for i in id_noname:
            cursor.execute(f"update product_all_api set state='2',remark='定制/专用/含禁止上架关键词，产品暂不通过' where id='{i}'")
            conn.commit()
        #for i_price, i_id in zip(price, fileName['product_zh_id']):
            #cursor.execute(f"update product_zh set price='{i_price}' where id='{i_id}'")
            #cursor.execute(f"update product_all set price='{i_price}' where product_zh_id='{i_id}'")
            #conn.commit()
        for i in id_buxiaoshou:
            cursor.execute(f"update product_all_api set state='2',remark='该链接无法定位到最终产品，存在多个价格' where id='{i}'")
            conn.commit()
        for i in id_ljcw:
            cursor.execute(f"update product_all_api set state='2',remark='链接有误，请按要求提供在销渠道证明' where id='{i}'")
            conn.commit()
        for i in id_qita:
            cursor.execute(f"update product_all_api set state='2',remark='其他销售渠道证明，需人工审核' where id='{i}'")
            conn.commit()
        for i in id_cfcf:
            cursor.execute(f"update product_all_api set state='2',remark='该链接与其他供应商提供链接重复，暂定不通过，正在处理，请稍等' where id='{i}'")
            conn.commit()
        for i in id_noding:
            cursor.execute(f"update product_all_api set state='2',remark='该链接无法定位到唯一商品' where id='{i}'")
            conn.commit()


    print('更新完成～')

def get_zgc_brand_info(url_brand_list,brand_list):

    conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311', password='zgcprice20200628',database='ZI_NEW',autocommit=True)
    cursor = conn.cursor()
    cursor.execute('select id,name,cname,ename from p_brand where id not in (select distinct(pid) from p_brand where pid <> 0)')  # 不匹配主品牌
    data = (cursor.fetchall())

    brand_table = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor.description]).drop_duplicates().fillna('EMPTY')
    brand_table['name'] = brand_table['name'].apply(lambda x : str(x).strip().upper())
    brand_table['cname'] = brand_table['cname'].apply(lambda x : str(x).strip().upper())
    brand_table['ename'] = brand_table['ename'].apply(lambda x : str(x).strip().upper())
    
    zgc_brand_list = []
    zgc_brand_code_list = []

    for brand,source_brand in zip(url_brand_list,brand_list):
        
        combine_list = [brand,source_brand]
        
        temp_name = []
        temp_code = []
        
        for brand in combine_list:

            if brand:
                if "联想" in str(brand):
                    brand = "联想"
                #if "国产" in str(brand):
                #    brand = "错误信息"
            else:
                brand = '无信息'
        
            brand = str(brand)
            try:
                country = brand.split('[')[1].split(']')[-2]
                brand = brand.replace(country, '')
            except IndexError:
                pass
            
            cn_res = ''.join(re.findall(r'[0-9\u4E00-\u9FA5]', brand))
            if cn_res.isdigit():
                cn_res = ''
    
            cnbrand = cn_res

            en_res = (''.join(re.findall(r'[a-zA-Z0-9-]', brand))).upper()
            if en_res.isdigit():
                en_res = ''
                
            enbrand = en_res
             
            if cnbrand == '':
                cnbrand = '无对应'
            if enbrand == '' or len(enbrand) == 1:
                enbrand = '无对应'
    
            findres = [[brandcode, name] for brandcode, enname,name in
                       zip(brand_table['id'].tolist(), brand_table['ename'].tolist(),brand_table['name'].tolist()) if enbrand == str(enname)]
            if findres:

                for find in findres:
                    temp_name.append(find[1])
                    temp_code.append(str(find[0]))
    
            else:
                if brand == "联想":
                    findres = [[brandcode, name] for brandcode, cnname,enname,name in
                               zip(brand_table['id'].tolist(), brand_table['cname'].tolist(),brand_table['ename'].tolist(),brand_table['name'].tolist()) if cnbrand == str(cnname) or "THINKPAD" in str(enname)]
                else:
                    findres = [[brandcode, name] for brandcode, cnname,name in
                               zip(brand_table['id'].tolist(), brand_table['cname'].tolist(),brand_table['name'].tolist()) if cnbrand == str(cnname)]
                    
                    if findres:
                        for find in findres:
                            temp_name.append(find[1])
                            temp_code.append(str(find[0]))
                        continue
                    else:
                        findres = [[brandcode, name] for brandcode,name in
                               zip(brand_table['id'].tolist(), brand_table['name'].tolist()) if brand == str(name)]
                    
                        if findres:

                            for find in findres:
                                temp_name.append(find[1])
                                temp_code.append(str(find[0]))
                            continue
            
                        else:
                            temp_name.append('无对应')
                            temp_code.append('无对应')
                            continue
                if findres:

                    for find in findres:
                        temp_name.append(find[1])
                        temp_code.append(str(find[0]))
    
                else:
                    temp_name.append('无对应')
                    temp_code.append('无对应')

        zgc_brand_list.append(temp_name)
        zgc_brand_code_list.append(temp_code)
        
    conn.close()
    return zgc_brand_list, zgc_brand_code_list


def get_zgc_classify_info(classify_list,source):
    
    conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311', password='zgcprice20200628',
                           database='ZI_DataBase')
    cursor = conn.cursor()
    if source == 'zi_zh':

        zd_category = []
        zd_category_code = []
        for subcategory_name in classify_list:
            #subcategory_name = '打印机'
            zd_category_single = []
            zd_category_code_single = []
            cursor.execute(f"select a.subcategoryname,b.SubCategoryCode from op_zh_zd_type a \
                           left join VW_Relation_Property b \
                           on a.subcategoryname = b.SubCategoryName \
                           where a.second = '{subcategory_name}'")
        
            data = (cursor.fetchall())
            data = pd.DataFrame(data,columns=[tuple[0] for tuple in cursor.description]).drop_duplicates()
            
            if data.empty:
                zd_category.append(['无总后类别对应'])
                zd_category_code.append(['无总后类别对应'])
            else:
                for name,code in zip(data['subcategoryname'].tolist(),data['SubCategoryCode']):
                    if code is None or "错误" in name:
                        continue
                    else:
                        zd_category_single.append(name)
                        zd_category_code_single.append(code)
                
                if zd_category_single:
                
                    zd_category.append(zd_category_single)
                    zd_category_code.append(zd_category_code_single)
                    
                else:
                    
                    zd_category.append(['无总后类别对应'])
                    zd_category_code.append(['无总后类别对应'])
                    
                
        return zd_category,zd_category_code
    else:
        source = source.replace('_', '').replace('ZH', '')
        zd_category = []
        zd_category_code = []
        for subcategory_name in classify_list:
            zd_category_single = []
            zd_category_code_single = []
            cursor.execute(f'''select b.name 'subcategoryname',a.ZI_SubCategoryCode 'SubCategoryCode' from Product_Relation_Attribute_SubTitle a LEFT JOIN ZI_SubCategory b
                                    on a.zi_subcategorycode=b.subcategorycode
                                    where a.source='{source}' and a.SourceSubCategory='{subcategory_name}'  ''')
            data = (cursor.fetchall())
            data = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor.description]).drop_duplicates()
            if data.empty:
                zd_category.append(['无总后类别对应'])
                zd_category_code.append(['无总后类别对应'])
            else:
                for name,code in zip(data['subcategoryname'].tolist(),data['SubCategoryCode']):
                    if code is None:
                        continue
                    else:
                        zd_category_single.append(name)
                        zd_category_code_single.append(code)
                zd_category.append(zd_category_single)
                zd_category_code.append(zd_category_code_single)
        return zd_category, zd_category_code



def remove_error_productcode(productcodes):
    '''
    排除productcode对应的子类或品牌包含错误两个字的productcode
    :param productcodes: 排重之后的productcode列表
    :return: 删除错误品牌之后的新productcode列表
    '''
    conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311', password='zgcprice20200628',database='ZI_DataBase', autocommit=True)
    cursor = conn.cursor()
    error_code = []
    sql = '''
    select distinct c.productcode,c.zi_brandname,d.name 'zi_subcategoryname' from 
    (select a.productcode,a.subcategorycode,b.name 'zi_brandname' from info_product a left join zi_brand b on a.brandcode=b.brandcode) c
    left join zi_subcategory d on c.subcategorycode=d.subcategorycode
    where c.productcode in (%s)
    ''' % ','.join(['%s'] * len(productcodes))
    cursor.execute(sql,tuple(productcodes))
    all_productcodes = cursor.fetchall()
    for i in all_productcodes:
        if '错误' in i[1] or '错误' in i[2]:
            error_code.append(i[0])
    return error_code

def remove_old_productcode(productcodes):

    conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311', password='zgcprice20200628',database='ZI_NEW', autocommit=True)
    cursor = conn.cursor()
    error_code = []
    
    for code in productcodes:
        cursor.execute(f"select sku from p_sku where sku = '{code}'")    
        check_df = pd.DataFrame(cursor.fetchall(), columns=[tuple[0] for tuple in cursor.description])
        if check_df.empty:
            error_code.append(code)
        else:
            pass
        
    conn.close()
    return error_code

def get_cn_number(char):
    """
    判断字符串中，中文的个数
    :param char: 字符串
    :return:
    """
    count = 0
    for item in char:
        if 0x4E00 <= ord(item) <= 0x9FA5:
            count += 1
    return count


def judge_unit(string):

    unit_list = ['MM','CM', 'DM', 'ML', 'W', 'KW','KG','G','M','L','KBPS','MMM','P','V','KM']
    error_unit_list = ['公斤','NULL','PVC','MONITOR','QIANG','I3','I5','I7','I9','LED','NO','寸','USB','OPTIX','OSN','ZXMP','BASE','ZFSD']
    
    for error_unit in error_unit_list:
        if error_unit in string:
            return False

    if get_cn_number(string) >= 3:
        return False
    elif not string[0].isdigit():
        return True
    m = 0
    n = 0
    for char in string:

        if char.isdigit() or char == '.' or char == '-' or char == 'X':
            m += 1
            if n != 0:
                m = m-1
                break
        elif char.isalpha():
            n += 1
        
    if string[m:m+n].upper() in unit_list:
        return False

    return True


def get_model(name, params, brand):
    #name = '得力（deli）A4浅红色复印纸 彩色打印纸手工折纸卡纸  ZFSD 80g100张/包 7757'
    #params = "{'产品型号': '得力7757', '产品详细参数': '得力\t彩色复印纸 A4 80g 210*297mm 100张/包 浅红 '}"
    #brand = '[得力]'
    try:
        params = eval(params)
    except:
        params = ''
    try:
        name = name.split('（')[0] + name.split('）')[1]
    except:
        try:
            name = name.split('(')[0] + name.split(')')[1]
        except:
            name = name
    
    
    brand = str(brand)
    
    brand_flag = 0
    speical_brand_list = ['得力','世达','华为']
    for special_brand in speical_brand_list:
        if special_brand in brand:
            brand_flag = 1

    try:
        brand_remove = re.findall(r"[A-Za-z0-9-]+", brand)[0].upper()
    except IndexError:
        brand_remove = '没有英文品牌！'
    param_model = ''
    if params:
        if '认证型号' in params.keys():
            param_model = params['认证型号']
            
        elif '产品型号' in params.keys():
            param_model = params['产品型号']
        elif '型号' in params:
            param_model = params['型号']
                
    else:
        pass
    
    param_model = param_model.upper()
    param_model = param_model.replace(brand_remove,'')
    if param_model:
        if judge_unit(param_model) == False:
            param_model = ''
        if '*' in param_model:
            param_model = ''
        if '×' in param_model:
             param_model = ''
        if param_model.isdigit() and brand_flag !=1:
            param_model = ''
    else:
        param_model = ''

    name_xinghao_lyst = list(filter(lambda x: len(x) >= 2, re.findall(r"[A-Za-z0-9-]+", name)))
    for i in range(len(name_xinghao_lyst)):
        name_xinghao_lyst[i] = name_xinghao_lyst[i].upper()
        name_xinghao_lyst[i] = name_xinghao_lyst[i].replace(brand_remove,'')
        if name_xinghao_lyst[i]:
            
            if judge_unit(name_xinghao_lyst[i]) == False:
                name_xinghao_lyst[i] = '?'
            if '*' in name_xinghao_lyst[i]:
                name_xinghao_lyst[i] = '?'
            if '×' in name_xinghao_lyst[i]:
                name_xinghao_lyst[i] = ''
            if name_xinghao_lyst[i].isdigit() and brand_flag !=1:
                name_xinghao_lyst[i] = '?'
        else:
            name_xinghao_lyst[i] = '?'
            
    if len(name_xinghao_lyst) == 0:
        return_model = param_model
    else:
        return_model = max(name_xinghao_lyst, key=len)
    
    if param_model:
        res_model = param_model
    else:
        res_model = return_model
    #res_model = max([param_model,return_model], key=len)
    
    if res_model == '?' or res_model == '':
        res_model = '无型号'
        

    if '/T' in res_model or '\T' in res_model:
        res_model = res_model.replace('/T','').replace('\T','')
     
    return res_model
            
            
''' 
        
    if len(name_xinghao_lyst) == 0:
        #type_lyst.append(param_xinghao.upper())
        if param_xinghao.isdigit():
            param_xinghao = '无型号'
            return param_xinghao
        else:
            return param_xinghao.upper()
    else:
        if param_xinghao in name_xinghao_lyst:
            #type_lyst.append(param_xinghao.upper())
            return param_xinghao.upper()
        else:
            xinghao_data = max(name_xinghao_lyst, key=len)
            for xinghao in name_xinghao_lyst:
                if len(xinghao) > 2 and '*' not in xinghao and judge_unit(xinghao):
                    xinghao_data = xinghao
                    break
            if not judge_unit(xinghao_data):
                xinghao_data == '无型号'
            #type_lyst.append(xinghao_data.upper())
            return xinghao_data
        
'''

def predict_category(name_list):
    '''
    获取预测类别结果
    :param name_list: 原始名称
    :return: 预测结果列表
    '''

    os.chdir("./text_moudle_LXWL")

    tf.reset_default_graph()

    model = LXWL_name2subcategory()
    category_list = model.namelyst_predict(name_list)
    
    os.chdir("../")

    return category_list

def fuzzy_match(zgc_brand_code_list,model_list,price_list):
    
    #获取库中所有产品信息
    conn = pymssql.connect('123.56.115.207','zgcindex','jiayou202006','ZI_NEW')
    cursor = conn.cursor()
    
    cursor.execute(f"select a.sku,a.skuname,b.brandid,c.index_price_wave from p_sku a \
                   left join p_spu b \
                   on a.spuid = b.id \
                   left join (select goods_id,index_price_wave from zdindex.dbo.zd_week_price where periods in (select top 1 periods from zdindex.dbo.zd_entry_goods_price))  c \
                   on a.sku = c.goods_id\
                  where a.state in ('1','4')")
    data = cursor.fetchall()
    df_db= pd.DataFrame(data, columns=[tuple[0] for tuple in cursor.description])

    res_name_list = []
    res_code_list = []
    for brand_code,model,price in zip(zgc_brand_code_list,model_list,price_list):
        try:
            price = int(float(price))
        except:
            price = 0
        try:
            brand_df = df_db[df_db['brandid'] == int(brand_code)]
        except:
            brand_df = df_db[df_db['brandid'] == str(brand_code)]
        
        temp_df = pd.DataFrame()
        temp_res_name_list = []
        temp_res_code_list = []
        temp_res_price_diff_list = []
        for name,product_code,index_price in zip(brand_df['skuname'].tolist(),brand_df['sku'].tolist(),brand_df['index_price_wave'].tolist()):

            if index_price == None:
                index_price = 0
                
            if str(model).strip().upper() in name.upper():
                
                if product_code not in temp_res_code_list:
                
                    temp_res_name_list.append(name)
                    temp_res_code_list.append(product_code)
                    temp_res_price_diff_list.append(abs(price-index_price))
                
        temp_df['name'] = temp_res_name_list
        temp_df['code'] = temp_res_code_list
        temp_df['diff'] = temp_res_price_diff_list
        
        temp_df = temp_df.sort_values('diff',ascending=True).head(3)
        
        res_name_list.append(temp_df['name'].tolist())    
        res_code_list.append(temp_df['code'].tolist())
    
    return res_name_list,res_code_list


def standard_point_sku_name(category_name,name_rules,cat_subtitle_df):
    

    
    conn_zi_new = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database= 'ZI_NEW',autocommit=True)
    cursor_zi_new = conn_zi_new.cursor()

    cursor_zi_new.execute(f"select * from vw_property where name in (select category_name from important_category)")
    data = cursor_zi_new.fetchall()
    subtitle_df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
    
    subtitle_df['require_param'] = subtitle_df['identy'].apply(lambda x: x[0])
    subtitle_df['match_param'] = subtitle_df['identy'].apply(lambda x: x[1])
    subtitle_df['standard_param'] = subtitle_df['identy'].apply(lambda x: x[2])
    subtitle_df['part_param'] = subtitle_df['identy'].apply(lambda x: x[3])


