#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Aug  6 10:21:46 2020

@author: rico
"""

import pymssql
import pandas as pd
from public.SKUMatchInfo.public_function import Index

from elasticsearch import Elasticsearch


def get_sku_match_res(channel,sku_list,engine):
    
    '''对供应商提供的SKU进行排重'''
    try:
        
        if engine == 'ES':
        
            es = Elasticsearch(hosts="http://localhost:9200/")
            
            query_json = {
                "query":{
                    "match":{"frm":f"{channel}"}
                    }
                }
            query = es.search(index='test_product_code_rel',body=query_json,scroll='5m', timeout='3s', size=10000)
            dict_ = dict(zip([query['hits']['hits'][i]['_source']['sku'] for i in range(query['hits']['total']['value'])],[query['hits']['hits'][i]['_source']['productcode'] for i in range(query['hits']['total']['value'])]))
            
            res_list = []
            for sku in sku_list:
                try:
                    results = dict_[sku] # es查询出的结果第一页
                except:
                    results = False
                res_list.append(results)
                
            res_dict = dict(zip(sku_list,res_list))
            
        elif engine == 'SQL':

            conn_zi_new = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database= 'ZI_NEW',autocommit=True)
            cursor_zi_new = conn_zi_new.cursor()
            
            cursor_zi_new.execute(f"select sku,productcode from Productcode_Sku where frm='{channel}'")
            data = cursor_zi_new.fetchall()
            code_df_source = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
            
            cursor_zi_new.execute(f"select sku,productcode from Productcode_Sku_Expand where frm='{channel}'")
            data = cursor_zi_new.fetchall()
            code_df_expand = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
            
            code_df = pd.concat([code_df_source,code_df_expand])
            code_df = code_df.drop_duplicates()
            
            res_list = list()
            if code_df.empty:
                
                conn_zi_new.close()
                code = 0
                msg = f"无{channel}渠道SKU对应关系"
                res = {'code':code,'msg':msg,'res_dict':{}}
                return res
            
            else:
                
                for sku in sku_list:
                    
                    if sku in code_df['sku'].tolist():
                        code = str(code_df[code_df['sku'] == sku]['productcode'].tolist()[0])
                        res_list.append(code)
                    else:
                        res_list.append(False)
            
            res_dict = dict(zip(sku_list,res_list))
            
        else:
            res = {'code':0,'msg':"非法引擎,请选择ES或SQL",'res_dict':{}}
            return res

            
             
        code = 1
        msg = "success"
        res = {'code':code,'msg':msg,'res_dict':res_dict}
        return res
    
    except Exception as e:
        code = 0
        msg = str(e)
        res = {'code':code,'msg':msg,'res_dict':{}}
        return res
    
def get_sku_match_res_backup(channel,sku_list):
    
    '''对供应商提供的SKU进行排重'''
    try:
        conn_zi_new = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database= 'ZI_NEW',autocommit=True)
        cursor_zi_new = conn_zi_new.cursor()
        
        cursor_zi_new.execute(f"select sku,productcode from Productcode_Sku where frm='{channel}'")
        data = cursor_zi_new.fetchall()
        code_df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
        
        res_list = list()
        if code_df.empty:
            
            conn_zi_new.close()
            code = 0
            msg = f"无{channel}渠道SKU对应关系"
            return code,msg,{}
        
        else:
            
            for sku in sku_list:
                
                if sku in code_df['sku'].tolist():
                    code = str(code_df[code_df['sku'] == sku]['productcode'].tolist()[0])
                    res_list.append(code)
                else:
                    res_list.append(False)
        
        res_dict = dict(zip(sku_list,res_list))
         
        code = 1
        msg = "success"
        conn_zi_new.close()
        res = {'code':code,'msg':msg,'res_dict':res_dict}
        return res

    
    except Exception as e:
        conn_zi_new.close()
        code = 0
        msg = str(e)
        res = {'code':code,'msg':msg,'res_dict':{}}
        return res
    
        
def get_url_match_res(channel_type,url_list):
    
    '''对供应商提供的url进行排重'''
    try:
        conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database= 'zdindex',autocommit=True)
        cursor = conn.cursor()
        
        if channel_type == 'DS':
            
            cursor.execute("select goods_id,goods_name,goods_url from zd_electricity_price  \
                           where periods in (select top 1 max(periods) from zd_entry_goods_price) \
                           and mall_id <> 'DS-SPU-HY' and data_status <> '-4' \
                           and (goods_url is not Null or goods_url <> '') ")

            data = cursor.fetchall()
            df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor.description])
        
        elif channel_type == 'ZC':
            
            cursor.execute("select goods_id,goods_name,goods_url from zd_purchase_price  \
                           where periods in (select top 1 max(periods) from zd_entry_goods_price) \
                           and purchase_id <> 'ZC-SPU-HY' and data_status <> '-4' \
                           and (goods_url is not Null or goods_url <> '')  ")

            data = cursor.fetchall()
            df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor.description])
        
        else:
            
            conn.close()
            code = 0
            msg = f"无{channel_type}渠道类别"
            res = {'code':code,'msg':msg,'res_dict':{}}
            return res
            
        
        res_list = list()
        for url in url_list:

            flag = False
            url = url.strip().upper()
            
            for db_url in df['goods_url'].unique().tolist():
                                
                db_url_ = db_url.strip().upper()
                
                #if url in db_url_ or db_url_ in url:
                if url in db_url_:
                    
                    code = df[df['goods_url'] == db_url]['goods_id'].tolist()[0]
                    res_list.append(code)
                    flag = True
                    break
            if flag:
                pass
            else:
                res_list.append(False)
                
        res_dict = dict(zip(url_list,res_list))
         
        code = 1
        msg = "success"
        conn.close()
        res = {'code':code,'msg':msg,'res_dict':res_dict}
        return res
    
    except Exception as e:
        conn.close()
        code = 0
        msg = str(e)
        res = {'code':code,'msg':msg,'res_dict':{}}
        return res
    

def get_name_match_res(channel_type,name_list):
    
    '''对供应商提供的url中的名字进行排重'''
    try:
        conn = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database= 'zdindex',autocommit=True)
        cursor = conn.cursor()
        
        if channel_type == 'DS':
            
            cursor.execute("select goods_id,goods_name,goods_url from zd_electricity_price  \
                           where periods in (select top 1 max(periods) from zd_entry_goods_price) \
                           and mall_id <> 'DS-SPU-HY' and data_status <> '-4' \
                           and (goods_name is not Null or goods_name <> '') ")

            data = cursor.fetchall()
            df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor.description])
        
        elif channel_type == 'ZC':
            
            cursor.execute("select goods_id,goods_name,goods_url from zd_purchase_price  \
                           where periods in (select top 1 max(periods) from zd_entry_goods_price) \
                           and purchase_id <> 'ZC-SPU-HY' and data_status <> '-4' \
                           and (goods_name is not Null or goods_name <> '')")

            data = cursor.fetchall()
            df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor.description])
        
        else:
            
            conn.close()
            code = 0
            msg = f"无{channel_type}渠道类别"
            res = {'code':code,'msg':msg,'res_dict':{}}
            return res
        
        res_list = list()
        for name in name_list:
            
            flag = False
            name = name.strip().upper()
            
            for db_name in df['goods_name'].unique().tolist():
                                
                db_name_ = db_name.strip().upper()
                
                if name in db_name_ or db_name_ in name:
                    
                    code = df[df['goods_name'] == db_name]['goods_id'].tolist()[0]
                    res_list.append(code)
                    flag = True
                    break
            if flag:
                pass
            else:
                res_list.append(False)
                
        res_dict = dict(zip(name_list,res_list))
         
        code = 1
        msg = "success"
        conn.close()
        res = {'code':code,'msg':msg,'res_dict':res_dict}
        return res

    
    except Exception as e:
        conn.close()
        code = 0
        msg = str(e)
        res = {'code':code,'msg':msg,'res_dict':{}}
        return res


def get_model_match_res(cust_category_list,zgc_brand_code_list,model_list,price_list):
    
    #模糊匹配，使用品牌+型号+价格   返回的结果按价格差的生序排列，取前三
    
    try:
        
        index_ = Index()
        counter = 1
        
        conn_zi_new = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database= 'ZI_NEW',autocommit=True)
        cursor_zi_new = conn_zi_new.cursor()
        
        cursor_zi_new.execute("select * from product_category_map where type = 'zd_cross_category'")
        data = cursor_zi_new.fetchall()
        category_map = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
        
        
        
        '''
        cursor_zi_new.execute(f"select a.sku,a.skuname,b.brandid,b.categoryid,c.name as 'categoryname',d.index_price_wave,a.state from p_sku a \
                       left join p_spu b \
                       on a.spuid = b.id \
                       left join p_category c \
                       on b.categoryid = c.id \
                       left join (select goods_id,index_price_wave from zdindex.dbo.zd_week_price where periods in (select top 1 periods from zdindex.dbo.zd_entry_goods_price))  d \
                       on a.sku = d.goods_id\
                      where a.state in ('1','2','4')")
        data = cursor_zi_new.fetchall()
        df_db= pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
        
        cursor_zi_new.execute(f"select a.sku,e.[value] as warranty from p_sku a \
                                left join p_skuvaluemap d \
                                on a.id = d.skuid \
                                left join p_skuvalue e \
                                on d.valueid = e.id \
                                left join p_skusubtitle f \
                                on e.subtitleid = f.id \
                                where a.state in ('1','2','4') and f.name = '质保时间'")
        data = cursor_zi_new.fetchall()
        warranty_df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
        '''
        cursor_zi_new.execute(f"select a.sku,a.skuname,b.brandid,b.categoryid,c.name as 'categoryname', \
                                d.maximumprice as 'index_price_wave',a.state from (select sku,skuname,spuid,state from p_sku where state in ('1','2','4'))a \
                                join p_spu b \
                               on a.spuid = b.id \
                                join p_category c \
                               on b.categoryid = c.id \
                               left join \
                               zi_database.dbo.zi_price_quote  d \
                               on a.sku = d.productcode")
        data = cursor_zi_new.fetchall()
        df_db= pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
        
        cursor_zi_new.execute(f"select a.sku,e.[value] as warranty from \
                                (select id,sku from p_sku where state in ('1','2','4')) a \
                                left join p_skuvaluemap d \
                                on a.id = d.skuid \
                                left join p_skuvalue e \
                                on d.valueid = e.id \
                                left join p_skusubtitle f \
                                on e.subtitleid = f.id \
                                where f.name = '质保时间'")
        data = cursor_zi_new.fetchall()
        warranty_df = pd.DataFrame(data, columns=[tuple[0] for tuple in cursor_zi_new.description])
        
    
        res_name_list = []
        res_code_list = []
        res_warranty_list = []
        res_state_list = []
        
        
        for cust_category,brand_code,model,price in zip(cust_category_list,zgc_brand_code_list,model_list,price_list):
            try:
                print(index_(counter, len(cust_category_list)-1), end='%')
            except:
                print(index_(counter, 1), end='%')
            counter += 1
            
            try:
                price = int(float(price))
            except:
                price = 0
                
            category_df = category_map[category_map['othersubcategory'] == cust_category][['subcategorycode']].drop_duplicates()
            if category_df.empty:
                combine_df = df_db[df_db['categoryname'] == cust_category]
            else:
                combine_df = pd.merge(category_df,df_db,left_on = 'subcategorycode',right_on = 'categoryid')
                
            try:
                brand_df = combine_df[combine_df['brandid'] == int(brand_code)]
            except:
                brand_df = combine_df[combine_df['brandid'] == str(brand_code)]

            temp_df = pd.DataFrame()
            temp_res_name_list = []
            temp_res_code_list = []
            temp_res_price_diff_list = []
            
            temp_res_warranty_list = []
            temp_res_state_list = []
            
            for name,product_code,index_price,state in zip(brand_df['skuname'].tolist(),brand_df['sku'].tolist(),brand_df['index_price_wave'].tolist(),brand_df['state'].tolist()):
    
                if index_price == None:
                    #index_price = 0
                    index_price = price
                    
                if str(model).strip().upper() in name.upper():
                    print(name)
                    
                    if product_code not in temp_res_code_list:
                    
                        temp_res_name_list.append(name)
                        temp_res_code_list.append(product_code)
                        temp_res_price_diff_list.append(abs(price-index_price))
                        
                        
                        try:
                            warranty = warranty_df[warranty_df['sku'] == product_code]['warranty'].tolist()[0]
                        except:
                            warranty = '无'
                        temp_res_warranty_list.append(warranty)
                        temp_res_state_list.append(str(state))
                        
                    
            temp_df['name'] = temp_res_name_list
            temp_df['code'] = temp_res_code_list
            temp_df['diff'] = temp_res_price_diff_list
            temp_df['warranty'] = temp_res_warranty_list
            temp_df['state'] = temp_res_state_list
            
            temp_df = temp_df.sort_values('diff',ascending=True).head(3)
            
            res_name_list.append(temp_df['name'].tolist())    
            res_code_list.append(temp_df['code'].tolist())
            res_warranty_list.append(temp_df['warranty'].tolist())
            res_state_list.append(temp_df['state'].tolist())
            
        conn_zi_new.close()
        
        code = 1
        msg = "success"
        res = {'code':code,'msg':msg,'res_name_list':res_name_list,'res_sku_list':res_code_list,'res_warranty_list':res_warranty_list,'res_state_list':res_state_list}
        return res

    
    except Exception as e:
        
        conn_zi_new.close()
        code = 0
        msg = str(e)
        res = {'code':code,'msg':msg,'res_name_list':[],'res_sku_list':[],'res_warranty_list':[],'res_state_list':[]}
        return res


#a,b = get_model_match_res(['20897','17057'],['8487','CRG-418C'],['9','825'],['1','2'])



def get_zgc_name_match_res(zgc_name_list):
    
    #匹配产品名称
    
    try:
    
        conn_zi_new = pymssql.connect(host='123.56.115.207', user='zgcprice3311',password='zgcprice20200628',database= 'ZI_NEW',autocommit=True)
        cursor_zi_new = conn_zi_new.cursor()
        #zgc_name_list = ['联想（THINKPAD） A系列 A285 （RYZEN 7 3700U/8GB/512GB SSD/集成显卡/WIN10HB/1年） 笔记本']
        res_code_list = list()
        for zgc_name in zgc_name_list:
            
            cursor_zi_new.execute(f"select sku from p_sku where skuname = '{zgc_name}' and state in ('1','2','4')")
            try:
                sku = cursor_zi_new.fetchone()[0]
            except:
                sku = '未匹配'
            res_code_list.append(sku)

        res_dict = dict(zip(zgc_name_list,res_code_list))        

        conn_zi_new.close()
        
        code = 1
        msg = "success"
        res = {'code':code,'msg':msg,'res_dict':res_dict}
        return res
    
    except Exception as e:
        
        conn_zi_new.close()
        code = 0
        msg = str(e)
        res = {'code':code,'msg':msg,'res_dict':{}}
        return res


#zgc_name_list = ['索尼 SONY HDR-CX450 数码摄像机 黑色','联想（THINKPAD） E系列 E14 （I5-10210U/8GB/512GB SSD/集成显卡/WIN10HB/1年） 笔记本','测试产品001']
#get_zgc_name_match_res(zgc_name_list)